// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.Search;

/// <summary>
/// The provisioning state of the shared private link resource. Valid values
/// are Updating, Deleting, Failed, Succeeded or Incomplete.
/// </summary>
public enum SearchServiceSharedPrivateLinkResourceProvisioningState
{
    /// <summary>
    /// The shared private link resource is in the process of being created
    /// along with other resources for it to be fully functional.
    /// </summary>
    Updating,

    /// <summary>
    /// The shared private link resource is in the process of being deleted.
    /// </summary>
    Deleting,

    /// <summary>
    /// The shared private link resource has failed to be provisioned or
    /// deleted.
    /// </summary>
    Failed,

    /// <summary>
    /// The shared private link resource has finished provisioning and is ready
    /// for approval.
    /// </summary>
    Succeeded,

    /// <summary>
    /// Provisioning request for the shared private link resource has been
    /// accepted but the process of creation has not commenced yet.
    /// </summary>
    Incomplete,
}
