// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Search;

/// <summary>
/// Describes the properties of an existing private endpoint connection to the
/// search service.
/// </summary>
public partial class SearchServicePrivateEndpointConnectionProperties : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrivateEndpointId 
    {
        get { Initialize(); return _privateEndpointId!; }
        set { Initialize(); _privateEndpointId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _privateEndpointId;

    /// <summary>
    /// Describes the current state of an existing Azure Private Link service
    /// connection to the private endpoint.
    /// </summary>
    public SearchServicePrivateLinkServiceConnectionState ConnectionState 
    {
        get { Initialize(); return _connectionState!; }
        set { Initialize(); AssignOrReplace(ref _connectionState, value); }
    }
    private SearchServicePrivateLinkServiceConnectionState? _connectionState;

    /// <summary>
    /// The group ID of the Azure resource for which the private link service
    /// is for.
    /// </summary>
    public BicepValue<string> GroupId 
    {
        get { Initialize(); return _groupId!; }
        set { Initialize(); _groupId!.Assign(value); }
    }
    private BicepValue<string>? _groupId;

    /// <summary>
    /// The provisioning state of the private link service connection. Valid
    /// values are Updating, Deleting, Failed, Succeeded, Incomplete, or
    /// Canceled.
    /// </summary>
    public BicepValue<SearchPrivateLinkServiceConnectionProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
        set { Initialize(); _provisioningState!.Assign(value); }
    }
    private BicepValue<SearchPrivateLinkServiceConnectionProvisioningState>? _provisioningState;

    /// <summary>
    /// Creates a new SearchServicePrivateEndpointConnectionProperties.
    /// </summary>
    public SearchServicePrivateEndpointConnectionProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SearchServicePrivateEndpointConnectionProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _privateEndpointId = DefineProperty<ResourceIdentifier>("PrivateEndpointId", ["privateEndpoint", "id"]);
        _connectionState = DefineModelProperty<SearchServicePrivateLinkServiceConnectionState>("ConnectionState", ["privateLinkServiceConnectionState"]);
        _groupId = DefineProperty<string>("GroupId", ["groupId"]);
        _provisioningState = DefineProperty<SearchPrivateLinkServiceConnectionProvisioningState>("ProvisioningState", ["provisioningState"]);
    }
}
