// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.Search;

/// <summary>
/// The provisioning state of the private link service connection. Valid values
/// are Updating, Deleting, Failed, Succeeded, Incomplete, or Canceled.
/// </summary>
public enum SearchPrivateLinkServiceConnectionProvisioningState
{
    /// <summary>
    /// The private link service connection is in the process of being created
    /// along with other resources for it to be fully functional.
    /// </summary>
    Updating,

    /// <summary>
    /// The private link service connection is in the process of being deleted.
    /// </summary>
    Deleting,

    /// <summary>
    /// The private link service connection has failed to be provisioned or
    /// deleted.
    /// </summary>
    Failed,

    /// <summary>
    /// The private link service connection has finished provisioning and is
    /// ready for approval.
    /// </summary>
    Succeeded,

    /// <summary>
    /// Provisioning request for the private link service connection resource
    /// has been accepted but the process of creation has not commenced yet.
    /// </summary>
    Incomplete,

    /// <summary>
    /// Provisioning request for the private link service connection resource
    /// has been canceled.
    /// </summary>
    Canceled,
}
