// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Search;

/// <summary>
/// Parameter group.
/// </summary>
public partial class SearchManagementRequestOptions : ProvisionableConstruct
{
    /// <summary>
    /// A client-generated GUID value that identifies this request. If
    /// specified, this will be included in response information as a way to
    /// track the request.
    /// </summary>
    public BicepValue<Guid> ClientRequestId 
    {
        get { Initialize(); return _clientRequestId!; }
        set { Initialize(); _clientRequestId!.Assign(value); }
    }
    private BicepValue<Guid>? _clientRequestId;

    /// <summary>
    /// Creates a new SearchManagementRequestOptions.
    /// </summary>
    public SearchManagementRequestOptions()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SearchManagementRequestOptions.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _clientRequestId = DefineProperty<Guid>("ClientRequestId", ["clientRequestId"]);
    }
}
