// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.Search;

/// <summary>
/// Describes a policy that determines how resources within the search service
/// are to be encrypted with customer managed keys.
/// </summary>
public partial class SearchEncryptionWithCmk : ProvisionableConstruct
{
    /// <summary>
    /// Describes how a search service should enforce compliance if it finds
    /// objects that aren&apos;t encrypted with the customer-managed key.
    /// </summary>
    public BicepValue<SearchEncryptionWithCmkEnforcement> Enforcement 
    {
        get { Initialize(); return _enforcement!; }
        set { Initialize(); _enforcement!.Assign(value); }
    }
    private BicepValue<SearchEncryptionWithCmkEnforcement>? _enforcement;

    /// <summary>
    /// Returns the status of search service compliance with respect to
    /// non-CMK-encrypted objects. If a service has more than one unencrypted
    /// object, and enforcement is enabled, the service is marked as
    /// noncompliant.
    /// </summary>
    public BicepValue<SearchEncryptionComplianceStatus> EncryptionComplianceStatus 
    {
        get { Initialize(); return _encryptionComplianceStatus!; }
    }
    private BicepValue<SearchEncryptionComplianceStatus>? _encryptionComplianceStatus;

    /// <summary>
    /// Creates a new SearchEncryptionWithCmk.
    /// </summary>
    public SearchEncryptionWithCmk()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SearchEncryptionWithCmk.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _enforcement = DefineProperty<SearchEncryptionWithCmkEnforcement>("Enforcement", ["enforcement"]);
        _encryptionComplianceStatus = DefineProperty<SearchEncryptionComplianceStatus>("EncryptionComplianceStatus", ["encryptionComplianceStatus"], isOutput: true);
    }
}
