// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Search;

/// <summary>
/// Defines the options for how the search service authenticates a data plane
/// request. This cannot be set if &apos;disableLocalAuth&apos; is set to true.
/// </summary>
public partial class SearchAadAuthDataPlaneAuthOptions : ProvisionableConstruct
{
    /// <summary>
    /// Indicates that only the API key can be used for authentication.
    /// To assign an object to this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepValue<BinaryData> ApiKeyOnly 
    {
        get { Initialize(); return _apiKeyOnly!; }
        set { Initialize(); _apiKeyOnly!.Assign(value); }
    }
    private BicepValue<BinaryData>? _apiKeyOnly;

    /// <summary>
    /// Describes what response the data plane API of a search service would
    /// send for requests that failed authentication.
    /// </summary>
    public BicepValue<SearchAadAuthFailureMode> AadAuthFailureMode 
    {
        get { Initialize(); return _aadAuthFailureMode!; }
        set { Initialize(); _aadAuthFailureMode!.Assign(value); }
    }
    private BicepValue<SearchAadAuthFailureMode>? _aadAuthFailureMode;

    /// <summary>
    /// Creates a new SearchAadAuthDataPlaneAuthOptions.
    /// </summary>
    public SearchAadAuthDataPlaneAuthOptions()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// SearchAadAuthDataPlaneAuthOptions.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _apiKeyOnly = DefineProperty<BinaryData>("ApiKeyOnly", ["apiKeyOnly"]);
        _aadAuthFailureMode = DefineProperty<SearchAadAuthFailureMode>("AadAuthFailureMode", ["aadOrApiKey", "aadAuthFailureMode"]);
    }
}
