// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Redis;

/// <summary>
/// SKU parameters supplied to the create Redis operation.
/// </summary>
public partial class RedisSku : ProvisionableConstruct
{
    /// <summary>
    /// The type of Redis cache to deploy. Valid values: (Basic, Standard,
    /// Premium).
    /// </summary>
    public BicepValue<RedisSkuName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<RedisSkuName>? _name;

    /// <summary>
    /// The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P =
    /// Premium).
    /// </summary>
    public BicepValue<RedisSkuFamily> Family 
    {
        get { Initialize(); return _family!; }
        set { Initialize(); _family!.Assign(value); }
    }
    private BicepValue<RedisSkuFamily>? _family;

    /// <summary>
    /// The size of the Redis cache to deploy. Valid values: for C
    /// (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for P (Premium) family
    /// (1, 2, 3, 4).
    /// </summary>
    public BicepValue<int> Capacity 
    {
        get { Initialize(); return _capacity!; }
        set { Initialize(); _capacity!.Assign(value); }
    }
    private BicepValue<int>? _capacity;

    /// <summary>
    /// Creates a new RedisSku.
    /// </summary>
    public RedisSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RedisSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<RedisSkuName>("Name", ["name"]);
        _family = DefineProperty<RedisSkuFamily>("Family", ["family"]);
        _capacity = DefineProperty<int>("Capacity", ["capacity"]);
    }
}
