// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.Redis;

/// <summary>
/// A class representing the RedisPrivateEndpointConnection data model.
/// The Private Endpoint Connection resource.
/// </summary>
public partial class RedisPrivateEndpointConnectionData : ProvisionableConstruct
{
    /// <summary>
    /// Gets Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrivateEndpointId 
    {
        get { Initialize(); return _privateEndpointId!; }
    }
    private BicepValue<ResourceIdentifier>? _privateEndpointId;

    /// <summary>
    /// A collection of information about the state of the connection between
    /// service consumer and provider.
    /// </summary>
    public RedisPrivateLinkServiceConnectionState RedisPrivateLinkServiceConnectionState 
    {
        get { Initialize(); return _redisPrivateLinkServiceConnectionState!; }
        set { Initialize(); AssignOrReplace(ref _redisPrivateLinkServiceConnectionState, value); }
    }
    private RedisPrivateLinkServiceConnectionState? _redisPrivateLinkServiceConnectionState;

    /// <summary>
    /// The provisioning state of the private endpoint connection resource.
    /// </summary>
    public BicepValue<RedisPrivateEndpointConnectionProvisioningState> RedisProvisioningState 
    {
        get { Initialize(); return _redisProvisioningState!; }
    }
    private BicepValue<RedisPrivateEndpointConnectionProvisioningState>? _redisProvisioningState;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new RedisPrivateEndpointConnectionData.
    /// </summary>
    public RedisPrivateEndpointConnectionData()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// RedisPrivateEndpointConnectionData.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _privateEndpointId = DefineProperty<ResourceIdentifier>("PrivateEndpointId", ["properties", "privateEndpoint", "id"], isOutput: true);
        _redisPrivateLinkServiceConnectionState = DefineModelProperty<RedisPrivateLinkServiceConnectionState>("RedisPrivateLinkServiceConnectionState", ["properties", "privateLinkServiceConnectionState"]);
        _redisProvisioningState = DefineProperty<RedisPrivateEndpointConnectionProvisioningState>("RedisProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }
}
