// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.Redis;

/// <summary>
/// All Redis Settings. Few possible keys:
/// rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,
/// maxmemory-policy,notify-keyspace-events, aof-backup-enabled,
/// aof-storage-connection-string-0, aof-storage-connection-string-1 etc.
/// </summary>
public partial class RedisCommonConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Specifies whether the rdb backup is enabled.
    /// </summary>
    public BicepValue<bool> IsRdbBackupEnabled 
    {
        get { Initialize(); return _isRdbBackupEnabled!; }
        set { Initialize(); _isRdbBackupEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isRdbBackupEnabled;

    /// <summary>
    /// Specifies the frequency for creating rdb backup in minutes. Valid
    /// values: (15, 30, 60, 360, 720, 1440).
    /// </summary>
    public BicepValue<string> RdbBackupFrequency 
    {
        get { Initialize(); return _rdbBackupFrequency!; }
        set { Initialize(); _rdbBackupFrequency!.Assign(value); }
    }
    private BicepValue<string>? _rdbBackupFrequency;

    /// <summary>
    /// Specifies the maximum number of snapshots for rdb backup.
    /// </summary>
    public BicepValue<int> RdbBackupMaxSnapshotCount 
    {
        get { Initialize(); return _rdbBackupMaxSnapshotCount!; }
        set { Initialize(); _rdbBackupMaxSnapshotCount!.Assign(value); }
    }
    private BicepValue<int>? _rdbBackupMaxSnapshotCount;

    /// <summary>
    /// The storage account connection string for storing rdb file.
    /// </summary>
    public BicepValue<string> RdbStorageConnectionString 
    {
        get { Initialize(); return _rdbStorageConnectionString!; }
        set { Initialize(); _rdbStorageConnectionString!.Assign(value); }
    }
    private BicepValue<string>? _rdbStorageConnectionString;

    /// <summary>
    /// Specifies whether the aof backup is enabled.
    /// </summary>
    public BicepValue<bool> IsAofBackupEnabled 
    {
        get { Initialize(); return _isAofBackupEnabled!; }
        set { Initialize(); _isAofBackupEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isAofBackupEnabled;

    /// <summary>
    /// First storage account connection string.
    /// </summary>
    public BicepValue<string> AofStorageConnectionString0 
    {
        get { Initialize(); return _aofStorageConnectionString0!; }
        set { Initialize(); _aofStorageConnectionString0!.Assign(value); }
    }
    private BicepValue<string>? _aofStorageConnectionString0;

    /// <summary>
    /// Second storage account connection string.
    /// </summary>
    public BicepValue<string> AofStorageConnectionString1 
    {
        get { Initialize(); return _aofStorageConnectionString1!; }
        set { Initialize(); _aofStorageConnectionString1!.Assign(value); }
    }
    private BicepValue<string>? _aofStorageConnectionString1;

    /// <summary>
    /// Value in megabytes reserved for fragmentation per shard.
    /// </summary>
    public BicepValue<string> MaxFragmentationMemoryReserved 
    {
        get { Initialize(); return _maxFragmentationMemoryReserved!; }
        set { Initialize(); _maxFragmentationMemoryReserved!.Assign(value); }
    }
    private BicepValue<string>? _maxFragmentationMemoryReserved;

    /// <summary>
    /// The eviction strategy used when your data won&apos;t fit within its
    /// memory limit.
    /// </summary>
    public BicepValue<string> MaxMemoryPolicy 
    {
        get { Initialize(); return _maxMemoryPolicy!; }
        set { Initialize(); _maxMemoryPolicy!.Assign(value); }
    }
    private BicepValue<string>? _maxMemoryPolicy;

    /// <summary>
    /// Value in megabytes reserved for non-cache usage per shard e.g. failover.
    /// </summary>
    public BicepValue<string> MaxMemoryReserved 
    {
        get { Initialize(); return _maxMemoryReserved!; }
        set { Initialize(); _maxMemoryReserved!.Assign(value); }
    }
    private BicepValue<string>? _maxMemoryReserved;

    /// <summary>
    /// Value in megabytes reserved for non-cache usage per shard e.g. failover.
    /// </summary>
    public BicepValue<string> MaxMemoryDelta 
    {
        get { Initialize(); return _maxMemoryDelta!; }
        set { Initialize(); _maxMemoryDelta!.Assign(value); }
    }
    private BicepValue<string>? _maxMemoryDelta;

    /// <summary>
    /// The max clients config.
    /// </summary>
    public BicepValue<string> MaxClients 
    {
        get { Initialize(); return _maxClients!; }
    }
    private BicepValue<string>? _maxClients;

    /// <summary>
    /// The keyspace events which should be monitored.
    /// </summary>
    public BicepValue<string> NotifyKeyspaceEvents 
    {
        get { Initialize(); return _notifyKeyspaceEvents!; }
        set { Initialize(); _notifyKeyspaceEvents!.Assign(value); }
    }
    private BicepValue<string>? _notifyKeyspaceEvents;

    /// <summary>
    /// Preferred auth method to communicate to storage account used for data
    /// archive, specify SAS or ManagedIdentity, default value is SAS.
    /// </summary>
    public BicepValue<string> PreferredDataArchiveAuthMethod 
    {
        get { Initialize(); return _preferredDataArchiveAuthMethod!; }
    }
    private BicepValue<string>? _preferredDataArchiveAuthMethod;

    /// <summary>
    /// Preferred auth method to communicate to storage account used for data
    /// persistence, specify SAS or ManagedIdentity, default value is SAS.
    /// </summary>
    public BicepValue<string> PreferredDataPersistenceAuthMethod 
    {
        get { Initialize(); return _preferredDataPersistenceAuthMethod!; }
        set { Initialize(); _preferredDataPersistenceAuthMethod!.Assign(value); }
    }
    private BicepValue<string>? _preferredDataPersistenceAuthMethod;

    /// <summary>
    /// Zonal Configuration.
    /// </summary>
    public BicepValue<string> ZonalConfiguration 
    {
        get { Initialize(); return _zonalConfiguration!; }
    }
    private BicepValue<string>? _zonalConfiguration;

    /// <summary>
    /// Specifies whether the authentication is disabled. Setting this property
    /// is highly discouraged from security point of view.
    /// </summary>
    public BicepValue<string> AuthNotRequired 
    {
        get { Initialize(); return _authNotRequired!; }
        set { Initialize(); _authNotRequired!.Assign(value); }
    }
    private BicepValue<string>? _authNotRequired;

    /// <summary>
    /// SubscriptionId of the storage account for persistence (aof/rdb) using
    /// ManagedIdentity.
    /// </summary>
    public BicepValue<string> StorageSubscriptionId 
    {
        get { Initialize(); return _storageSubscriptionId!; }
        set { Initialize(); _storageSubscriptionId!.Assign(value); }
    }
    private BicepValue<string>? _storageSubscriptionId;

    /// <summary>
    /// Specifies whether AAD based authentication has been enabled or disabled
    /// for the cache.
    /// </summary>
    public BicepValue<string> IsAadEnabled 
    {
        get { Initialize(); return _isAadEnabled!; }
        set { Initialize(); _isAadEnabled!.Assign(value); }
    }
    private BicepValue<string>? _isAadEnabled;

    /// <summary>
    /// Additional Properties                          To assign an object to
    /// the value of this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepDictionary<BinaryData> AdditionalProperties 
    {
        get { Initialize(); return _additionalProperties!; }
        set { Initialize(); _additionalProperties!.Assign(value); }
    }
    private BicepDictionary<BinaryData>? _additionalProperties;

    /// <summary>
    /// Creates a new RedisCommonConfiguration.
    /// </summary>
    public RedisCommonConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RedisCommonConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isRdbBackupEnabled = DefineProperty<bool>("IsRdbBackupEnabled", ["rdb-backup-enabled"]);
        _rdbBackupFrequency = DefineProperty<string>("RdbBackupFrequency", ["rdb-backup-frequency"]);
        _rdbBackupMaxSnapshotCount = DefineProperty<int>("RdbBackupMaxSnapshotCount", ["rdb-backup-max-snapshot-count"]);
        _rdbStorageConnectionString = DefineProperty<string>("RdbStorageConnectionString", ["rdb-storage-connection-string"]);
        _isAofBackupEnabled = DefineProperty<bool>("IsAofBackupEnabled", ["aof-backup-enabled"]);
        _aofStorageConnectionString0 = DefineProperty<string>("AofStorageConnectionString0", ["aof-storage-connection-string-0"]);
        _aofStorageConnectionString1 = DefineProperty<string>("AofStorageConnectionString1", ["aof-storage-connection-string-1"]);
        _maxFragmentationMemoryReserved = DefineProperty<string>("MaxFragmentationMemoryReserved", ["maxfragmentationmemory-reserved"]);
        _maxMemoryPolicy = DefineProperty<string>("MaxMemoryPolicy", ["maxmemory-policy"]);
        _maxMemoryReserved = DefineProperty<string>("MaxMemoryReserved", ["maxmemory-reserved"]);
        _maxMemoryDelta = DefineProperty<string>("MaxMemoryDelta", ["maxmemory-delta"]);
        _maxClients = DefineProperty<string>("MaxClients", ["maxclients"], isOutput: true);
        _notifyKeyspaceEvents = DefineProperty<string>("NotifyKeyspaceEvents", ["notify-keyspace-events"]);
        _preferredDataArchiveAuthMethod = DefineProperty<string>("PreferredDataArchiveAuthMethod", ["preferred-data-archive-auth-method"], isOutput: true);
        _preferredDataPersistenceAuthMethod = DefineProperty<string>("PreferredDataPersistenceAuthMethod", ["preferred-data-persistence-auth-method"]);
        _zonalConfiguration = DefineProperty<string>("ZonalConfiguration", ["zonal-configuration"], isOutput: true);
        _authNotRequired = DefineProperty<string>("AuthNotRequired", ["authnotrequired"]);
        _storageSubscriptionId = DefineProperty<string>("StorageSubscriptionId", ["storage-subscription-id"]);
        _isAadEnabled = DefineProperty<string>("IsAadEnabled", ["aad-enabled"]);
        _additionalProperties = DefineDictionaryProperty<BinaryData>("AdditionalProperties", ["AdditionalProperties"]);
    }
}
