// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.Redis;

/// <summary>
/// Redis cache access keys.
/// </summary>
public partial class RedisAccessKeys : ProvisionableConstruct
{
    /// <summary>
    /// The current primary key that clients can use to authenticate with Redis
    /// cache.
    /// </summary>
    public BicepValue<string> PrimaryKey 
    {
        get { Initialize(); return _primaryKey!; }
    }
    private BicepValue<string>? _primaryKey;

    /// <summary>
    /// The current secondary key that clients can use to authenticate with
    /// Redis cache.
    /// </summary>
    public BicepValue<string> SecondaryKey 
    {
        get { Initialize(); return _secondaryKey!; }
    }
    private BicepValue<string>? _secondaryKey;

    /// <summary>
    /// Creates a new RedisAccessKeys.
    /// </summary>
    public RedisAccessKeys()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RedisAccessKeys.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _primaryKey = DefineProperty<string>("PrimaryKey", ["primaryKey"], isOutput: true, isSecure: true);
        _secondaryKey = DefineProperty<string>("SecondaryKey", ["secondaryKey"], isOutput: true, isSecure: true);
    }
}
