// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// PostgreSqlVirtualNetworkRule.
/// </summary>
public partial class PostgreSqlVirtualNetworkRule : ProvisionableResource
{
    /// <summary>
    /// The name of the virtual network rule.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Create firewall rule before the virtual network has vnet service
    /// endpoint enabled.
    /// </summary>
    public BicepValue<bool> IgnoreMissingVnetServiceEndpoint 
    {
        get { Initialize(); return _ignoreMissingVnetServiceEndpoint!; }
        set { Initialize(); _ignoreMissingVnetServiceEndpoint!.Assign(value); }
    }
    private BicepValue<bool>? _ignoreMissingVnetServiceEndpoint;

    /// <summary>
    /// The ARM resource id of the virtual network subnet.
    /// </summary>
    public BicepValue<ResourceIdentifier> VirtualNetworkSubnetId 
    {
        get { Initialize(); return _virtualNetworkSubnetId!; }
        set { Initialize(); _virtualNetworkSubnetId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _virtualNetworkSubnetId;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Virtual Network Rule State.
    /// </summary>
    public BicepValue<PostgreSqlVirtualNetworkRuleState> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<PostgreSqlVirtualNetworkRuleState>? _state;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent PostgreSqlServer.
    /// </summary>
    public PostgreSqlServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<PostgreSqlServer>? _parent;

    /// <summary>
    /// Creates a new PostgreSqlVirtualNetworkRule.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlVirtualNetworkRule
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlVirtualNetworkRule.</param>
    public PostgreSqlVirtualNetworkRule(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.DBforPostgreSQL/servers/virtualNetworkRules", resourceVersion ?? "2017-12-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PostgreSqlVirtualNetworkRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _ignoreMissingVnetServiceEndpoint = DefineProperty<bool>("IgnoreMissingVnetServiceEndpoint", ["properties", "ignoreMissingVnetServiceEndpoint"]);
        _virtualNetworkSubnetId = DefineProperty<ResourceIdentifier>("VirtualNetworkSubnetId", ["properties", "virtualNetworkSubnetId"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _state = DefineProperty<PostgreSqlVirtualNetworkRuleState>("State", ["properties", "state"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<PostgreSqlServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported PostgreSqlVirtualNetworkRule resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2017-12-01.
        /// </summary>
        public static readonly string V2017_12_01 = "2017-12-01";
    }

    /// <summary>
    /// Creates a reference to an existing PostgreSqlVirtualNetworkRule.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlVirtualNetworkRule
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlVirtualNetworkRule.</param>
    /// <returns>The existing PostgreSqlVirtualNetworkRule resource.</returns>
    public static PostgreSqlVirtualNetworkRule FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this PostgreSqlVirtualNetworkRule
    /// resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 128, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);
}
