// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// PostgreSqlServerAdministrator.
/// </summary>
public partial class PostgreSqlServerAdministrator : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The type of administrator.
    /// </summary>
    public BicepValue<PostgreSqlAdministratorType> AdministratorType 
    {
        get { Initialize(); return _administratorType!; }
        set { Initialize(); _administratorType!.Assign(value); }
    }
    private BicepValue<PostgreSqlAdministratorType>? _administratorType;

    /// <summary>
    /// The server administrator login account name.
    /// </summary>
    public BicepValue<string> LoginAccountName 
    {
        get { Initialize(); return _loginAccountName!; }
        set { Initialize(); _loginAccountName!.Assign(value); }
    }
    private BicepValue<string>? _loginAccountName;

    /// <summary>
    /// The server administrator Sid (Secure ID).
    /// </summary>
    public BicepValue<Guid> SecureId 
    {
        get { Initialize(); return _secureId!; }
        set { Initialize(); _secureId!.Assign(value); }
    }
    private BicepValue<Guid>? _secureId;

    /// <summary>
    /// The server Active Directory Administrator tenant id.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
        set { Initialize(); _tenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent PostgreSqlServer.
    /// </summary>
    public PostgreSqlServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<PostgreSqlServer>? _parent;

    /// <summary>
    /// Creates a new PostgreSqlServerAdministrator.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlServerAdministrator
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlServerAdministrator.</param>
    public PostgreSqlServerAdministrator(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.DBforPostgreSQL/servers/administrators", resourceVersion ?? "2017-12-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlServerAdministrator.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _administratorType = DefineProperty<PostgreSqlAdministratorType>("AdministratorType", ["properties", "administratorType"]);
        _loginAccountName = DefineProperty<string>("LoginAccountName", ["properties", "login"]);
        _secureId = DefineProperty<Guid>("SecureId", ["properties", "sid"]);
        _tenantId = DefineProperty<Guid>("TenantId", ["properties", "tenantId"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<PostgreSqlServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported PostgreSqlServerAdministrator resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2017-12-01.
        /// </summary>
        public static readonly string V2017_12_01 = "2017-12-01";
    }

    /// <summary>
    /// Creates a reference to an existing PostgreSqlServerAdministrator.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlServerAdministrator
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlServerAdministrator.</param>
    /// <returns>The existing PostgreSqlServerAdministrator resource.</returns>
    public static PostgreSqlServerAdministrator FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
