// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// PostgreSqlServer.
/// </summary>
public partial class PostgreSqlServer : ProvisionableResource
{
    /// <summary>
    /// The name of the server.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The location the resource resides in.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Properties of the server.             Please note
    /// Azure.ResourceManager.PostgreSql.Models.PostgreSqlServerPropertiesForCreate
    /// is the base class. According to the scenario, a derived class of the
    /// base class might need to be assigned here, or this property needs to
    /// be casted to one of the possible derived classes.             The
    /// available derived classes include
    /// Azure.ResourceManager.PostgreSql.Models.PostgreSqlServerPropertiesForDefaultCreate,
    /// Azure.ResourceManager.PostgreSql.Models.PostgreSqlServerPropertiesForGeoRestore,
    /// Azure.ResourceManager.PostgreSql.Models.PostgreSqlServerPropertiesForRestore
    /// and
    /// Azure.ResourceManager.PostgreSql.Models.PostgreSqlServerPropertiesForReplica.
    /// </summary>
    public PostgreSqlServerPropertiesForCreate Properties 
    {
        get { Initialize(); return _properties!; }
        set { Initialize(); AssignOrReplace(ref _properties, value); }
    }
    private PostgreSqlServerPropertiesForCreate? _properties;

    /// <summary>
    /// The Azure Active Directory identity of the server. Current supported
    /// identity types: SystemAssigned.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// The SKU (pricing tier) of the server.
    /// </summary>
    public PostgreSqlSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private PostgreSqlSku? _sku;

    /// <summary>
    /// Application-specific metadata in the form of key-value pairs.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// The administrator&apos;s login name of a server. Can only be specified
    /// when the server is being created (and is required for creation).
    /// </summary>
    public BicepValue<string> AdministratorLogin 
    {
        get { Initialize(); return _administratorLogin!; }
    }
    private BicepValue<string>? _administratorLogin;

    /// <summary>
    /// Status showing whether the server data encryption is enabled with
    /// customer-managed keys.
    /// </summary>
    public BicepValue<string> ByokEnforcement 
    {
        get { Initialize(); return _byokEnforcement!; }
    }
    private BicepValue<string>? _byokEnforcement;

    /// <summary>
    /// Earliest restore point creation time (ISO8601 format).
    /// </summary>
    public BicepValue<DateTimeOffset> EarliestRestoreOn 
    {
        get { Initialize(); return _earliestRestoreOn!; }
    }
    private BicepValue<DateTimeOffset>? _earliestRestoreOn;

    /// <summary>
    /// The fully qualified domain name of a server.
    /// </summary>
    public BicepValue<string> FullyQualifiedDomainName 
    {
        get { Initialize(); return _fullyQualifiedDomainName!; }
    }
    private BicepValue<string>? _fullyQualifiedDomainName;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Status showing whether the server enabled infrastructure encryption.
    /// </summary>
    public BicepValue<PostgreSqlInfrastructureEncryption> InfrastructureEncryption 
    {
        get { Initialize(); return _infrastructureEncryption!; }
    }
    private BicepValue<PostgreSqlInfrastructureEncryption>? _infrastructureEncryption;

    /// <summary>
    /// The master server id of a replica server.
    /// </summary>
    public BicepValue<ResourceIdentifier> MasterServerId 
    {
        get { Initialize(); return _masterServerId!; }
    }
    private BicepValue<ResourceIdentifier>? _masterServerId;

    /// <summary>
    /// Enforce a minimal Tls version for the server.
    /// </summary>
    public BicepValue<PostgreSqlMinimalTlsVersionEnum> MinimalTlsVersion 
    {
        get { Initialize(); return _minimalTlsVersion!; }
    }
    private BicepValue<PostgreSqlMinimalTlsVersionEnum>? _minimalTlsVersion;

    /// <summary>
    /// List of private endpoint connections on a server.
    /// </summary>
    public BicepList<PostgreSqlServerPrivateEndpointConnection> PrivateEndpointConnections 
    {
        get { Initialize(); return _privateEndpointConnections!; }
    }
    private BicepList<PostgreSqlServerPrivateEndpointConnection>? _privateEndpointConnections;

    /// <summary>
    /// Whether or not public network access is allowed for this server. Value
    /// is optional but if passed in, must be &apos;Enabled&apos; or
    /// &apos;Disabled&apos;.
    /// </summary>
    public BicepValue<PostgreSqlPublicNetworkAccessEnum> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
    }
    private BicepValue<PostgreSqlPublicNetworkAccessEnum>? _publicNetworkAccess;

    /// <summary>
    /// The maximum number of replicas that a master server can have.
    /// </summary>
    public BicepValue<int> ReplicaCapacity 
    {
        get { Initialize(); return _replicaCapacity!; }
    }
    private BicepValue<int>? _replicaCapacity;

    /// <summary>
    /// The replication role of the server.
    /// </summary>
    public BicepValue<string> ReplicationRole 
    {
        get { Initialize(); return _replicationRole!; }
    }
    private BicepValue<string>? _replicationRole;

    /// <summary>
    /// Enable ssl enforcement or not when connect to server.
    /// </summary>
    public BicepValue<PostgreSqlSslEnforcementEnum> SslEnforcement 
    {
        get { Initialize(); return _sslEnforcement!; }
    }
    private BicepValue<PostgreSqlSslEnforcementEnum>? _sslEnforcement;

    /// <summary>
    /// Storage profile of a server.
    /// </summary>
    public PostgreSqlStorageProfile StorageProfile 
    {
        get { Initialize(); return _storageProfile!; }
    }
    private PostgreSqlStorageProfile? _storageProfile;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// A state of a server that is visible to user.
    /// </summary>
    public BicepValue<PostgreSqlServerState> UserVisibleState 
    {
        get { Initialize(); return _userVisibleState!; }
    }
    private BicepValue<PostgreSqlServerState>? _userVisibleState;

    /// <summary>
    /// Server version.
    /// </summary>
    public BicepValue<PostgreSqlServerVersion> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<PostgreSqlServerVersion>? _version;

    /// <summary>
    /// Creates a new PostgreSqlServer.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlServer resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlServer.</param>
    public PostgreSqlServer(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.DBforPostgreSQL/servers", resourceVersion ?? "2017-12-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PostgreSqlServer.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _properties = DefineModelProperty<PostgreSqlServerPropertiesForCreate>("Properties", ["properties"], isRequired: true);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"]);
        _sku = DefineModelProperty<PostgreSqlSku>("Sku", ["sku"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _administratorLogin = DefineProperty<string>("AdministratorLogin", ["properties", "administratorLogin"], isOutput: true);
        _byokEnforcement = DefineProperty<string>("ByokEnforcement", ["properties", "byokEnforcement"], isOutput: true);
        _earliestRestoreOn = DefineProperty<DateTimeOffset>("EarliestRestoreOn", ["properties", "earliestRestoreDate"], isOutput: true);
        _fullyQualifiedDomainName = DefineProperty<string>("FullyQualifiedDomainName", ["properties", "fullyQualifiedDomainName"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _infrastructureEncryption = DefineProperty<PostgreSqlInfrastructureEncryption>("InfrastructureEncryption", ["properties", "infrastructureEncryption"], isOutput: true);
        _masterServerId = DefineProperty<ResourceIdentifier>("MasterServerId", ["properties", "masterServerId"], isOutput: true);
        _minimalTlsVersion = DefineProperty<PostgreSqlMinimalTlsVersionEnum>("MinimalTlsVersion", ["properties", "minimalTlsVersion"], isOutput: true);
        _privateEndpointConnections = DefineListProperty<PostgreSqlServerPrivateEndpointConnection>("PrivateEndpointConnections", ["properties", "privateEndpointConnections"], isOutput: true);
        _publicNetworkAccess = DefineProperty<PostgreSqlPublicNetworkAccessEnum>("PublicNetworkAccess", ["properties", "publicNetworkAccess"], isOutput: true);
        _replicaCapacity = DefineProperty<int>("ReplicaCapacity", ["properties", "replicaCapacity"], isOutput: true);
        _replicationRole = DefineProperty<string>("ReplicationRole", ["properties", "replicationRole"], isOutput: true);
        _sslEnforcement = DefineProperty<PostgreSqlSslEnforcementEnum>("SslEnforcement", ["properties", "sslEnforcement"], isOutput: true);
        _storageProfile = DefineModelProperty<PostgreSqlStorageProfile>("StorageProfile", ["properties", "storageProfile"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _userVisibleState = DefineProperty<PostgreSqlServerState>("UserVisibleState", ["properties", "userVisibleState"], isOutput: true);
        _version = DefineProperty<PostgreSqlServerVersion>("Version", ["properties", "version"], isOutput: true);
    }

    /// <summary>
    /// Supported PostgreSqlServer resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2017-12-01.
        /// </summary>
        public static readonly string V2017_12_01 = "2017-12-01";
    }

    /// <summary>
    /// Creates a reference to an existing PostgreSqlServer.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlServer resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlServer.</param>
    /// <returns>The existing PostgreSqlServer resource.</returns>
    public static PostgreSqlServer FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this PostgreSqlServer resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 3, maxLength: 63, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);
}
