// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// PostgreSqlMigration.
/// </summary>
public partial class PostgreSqlMigration : ProvisionableResource
{
    /// <summary>
    /// The name of the migration.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// To trigger cancel for entire migration we need to send this flag as
    /// True.
    /// </summary>
    public BicepValue<PostgreSqlMigrationCancel> Cancel 
    {
        get { Initialize(); return _cancel!; }
        set { Initialize(); _cancel!.Assign(value); }
    }
    private BicepValue<PostgreSqlMigrationCancel>? _cancel;

    /// <summary>
    /// When you want to trigger cancel for specific databases send cancel flag
    /// as True and database names in this array.
    /// </summary>
    public BicepList<string> DbsToCancelMigrationOn 
    {
        get { Initialize(); return _dbsToCancelMigrationOn!; }
        set { Initialize(); _dbsToCancelMigrationOn!.Assign(value); }
    }
    private BicepList<string>? _dbsToCancelMigrationOn;

    /// <summary>
    /// Number of databases to migrate.
    /// </summary>
    public BicepList<string> DbsToMigrate 
    {
        get { Initialize(); return _dbsToMigrate!; }
        set { Initialize(); _dbsToMigrate!.Assign(value); }
    }
    private BicepList<string>? _dbsToMigrate;

    /// <summary>
    /// When you want to trigger cutover for specific databases send
    /// triggerCutover flag as True and database names in this array.
    /// </summary>
    public BicepList<string> DbsToTriggerCutoverOn 
    {
        get { Initialize(); return _dbsToTriggerCutoverOn!; }
        set { Initialize(); _dbsToTriggerCutoverOn!.Assign(value); }
    }
    private BicepList<string>? _dbsToTriggerCutoverOn;

    /// <summary>
    /// There are two types of migration modes Online and Offline.
    /// </summary>
    public BicepValue<PostgreSqlMigrationMode> MigrationMode 
    {
        get { Initialize(); return _migrationMode!; }
        set { Initialize(); _migrationMode!.Assign(value); }
    }
    private BicepValue<PostgreSqlMigrationMode>? _migrationMode;

    /// <summary>
    /// End time in UTC for migration window.
    /// </summary>
    public BicepValue<DateTimeOffset> MigrationWindowEndTimeInUtc 
    {
        get { Initialize(); return _migrationWindowEndTimeInUtc!; }
        set { Initialize(); _migrationWindowEndTimeInUtc!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _migrationWindowEndTimeInUtc;

    /// <summary>
    /// Start time in UTC for migration window.
    /// </summary>
    public BicepValue<DateTimeOffset> MigrationWindowStartTimeInUtc 
    {
        get { Initialize(); return _migrationWindowStartTimeInUtc!; }
        set { Initialize(); _migrationWindowStartTimeInUtc!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _migrationWindowStartTimeInUtc;

    /// <summary>
    /// Indicates whether the databases on the target server can be
    /// overwritten, if already present. If set to False, the migration
    /// workflow will wait for a confirmation, if it detects that the database
    /// already exists.
    /// </summary>
    public BicepValue<PostgreSqlMigrationOverwriteDbsInTarget> OverwriteDbsInTarget 
    {
        get { Initialize(); return _overwriteDbsInTarget!; }
        set { Initialize(); _overwriteDbsInTarget!.Assign(value); }
    }
    private BicepValue<PostgreSqlMigrationOverwriteDbsInTarget>? _overwriteDbsInTarget;

    /// <summary>
    /// Migration secret parameters.
    /// </summary>
    public PostgreSqlMigrationSecretParameters SecretParameters 
    {
        get { Initialize(); return _secretParameters!; }
        set { Initialize(); AssignOrReplace(ref _secretParameters, value); }
    }
    private PostgreSqlMigrationSecretParameters? _secretParameters;

    /// <summary>
    /// Indicates whether to setup LogicalReplicationOnSourceDb, if needed.
    /// </summary>
    public BicepValue<PostgreSqlMigrationLogicalReplicationOnSourceDb> SetupLogicalReplicationOnSourceDbIfNeeded 
    {
        get { Initialize(); return _setupLogicalReplicationOnSourceDbIfNeeded!; }
        set { Initialize(); _setupLogicalReplicationOnSourceDbIfNeeded!.Assign(value); }
    }
    private BicepValue<PostgreSqlMigrationLogicalReplicationOnSourceDb>? _setupLogicalReplicationOnSourceDbIfNeeded;

    /// <summary>
    /// Source server fully qualified domain name or ip. It is a optional
    /// value, if customer provide it, dms will always use it for connection.
    /// </summary>
    public BicepValue<string> SourceDbServerFullyQualifiedDomainName 
    {
        get { Initialize(); return _sourceDbServerFullyQualifiedDomainName!; }
        set { Initialize(); _sourceDbServerFullyQualifiedDomainName!.Assign(value); }
    }
    private BicepValue<string>? _sourceDbServerFullyQualifiedDomainName;

    /// <summary>
    /// ResourceId of the source database server.
    /// </summary>
    public BicepValue<ResourceIdentifier> SourceDbServerResourceId 
    {
        get { Initialize(); return _sourceDbServerResourceId!; }
        set { Initialize(); _sourceDbServerResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _sourceDbServerResourceId;

    /// <summary>
    /// Indicates whether the data migration should start right away.
    /// </summary>
    public BicepValue<PostgreSqlMigrationStartDataMigration> StartDataMigration 
    {
        get { Initialize(); return _startDataMigration!; }
        set { Initialize(); _startDataMigration!.Assign(value); }
    }
    private BicepValue<PostgreSqlMigrationStartDataMigration>? _startDataMigration;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Target server fully qualified domain name or ip. It is a optional
    /// value, if customer provide it, dms will always use it for connection.
    /// </summary>
    public BicepValue<string> TargetDbServerFullyQualifiedDomainName 
    {
        get { Initialize(); return _targetDbServerFullyQualifiedDomainName!; }
        set { Initialize(); _targetDbServerFullyQualifiedDomainName!.Assign(value); }
    }
    private BicepValue<string>? _targetDbServerFullyQualifiedDomainName;

    /// <summary>
    /// To trigger cutover for entire migration we need to send this flag as
    /// True.
    /// </summary>
    public BicepValue<PostgreSqlMigrationTriggerCutover> TriggerCutover 
    {
        get { Initialize(); return _triggerCutover!; }
        set { Initialize(); _triggerCutover!.Assign(value); }
    }
    private BicepValue<PostgreSqlMigrationTriggerCutover>? _triggerCutover;

    /// <summary>
    /// Current status of migration.
    /// </summary>
    public PostgreSqlMigrationStatus CurrentStatus 
    {
        get { Initialize(); return _currentStatus!; }
    }
    private PostgreSqlMigrationStatus? _currentStatus;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// ID for migration, a GUID.
    /// </summary>
    public BicepValue<string> MigrationId 
    {
        get { Initialize(); return _migrationId!; }
    }
    private BicepValue<string>? _migrationId;

    /// <summary>
    /// Metadata of the source database server.
    /// </summary>
    public PostgreSqlServerMetadata SourceDbServerMetadata 
    {
        get { Initialize(); return _sourceDbServerMetadata!; }
    }
    private PostgreSqlServerMetadata? _sourceDbServerMetadata;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Metadata of the target database server.
    /// </summary>
    public PostgreSqlServerMetadata TargetDbServerMetadata 
    {
        get { Initialize(); return _targetDbServerMetadata!; }
    }
    private PostgreSqlServerMetadata? _targetDbServerMetadata;

    /// <summary>
    /// ResourceId of the source database server.
    /// </summary>
    public BicepValue<ResourceIdentifier> TargetDbServerResourceId 
    {
        get { Initialize(); return _targetDbServerResourceId!; }
    }
    private BicepValue<ResourceIdentifier>? _targetDbServerResourceId;

    /// <summary>
    /// Gets or sets a reference to the parent PostgreSqlFlexibleServer.
    /// </summary>
    public PostgreSqlFlexibleServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<PostgreSqlFlexibleServer>? _parent;

    /// <summary>
    /// Creates a new PostgreSqlMigration.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlMigration resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlMigration.</param>
    public PostgreSqlMigration(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.DBforPostgreSQL/flexibleServers/migrations", resourceVersion ?? "2024-08-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PostgreSqlMigration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _cancel = DefineProperty<PostgreSqlMigrationCancel>("Cancel", ["properties", "cancel"]);
        _dbsToCancelMigrationOn = DefineListProperty<string>("DbsToCancelMigrationOn", ["properties", "dbsToCancelMigrationOn"]);
        _dbsToMigrate = DefineListProperty<string>("DbsToMigrate", ["properties", "dbsToMigrate"]);
        _dbsToTriggerCutoverOn = DefineListProperty<string>("DbsToTriggerCutoverOn", ["properties", "dbsToTriggerCutoverOn"]);
        _migrationMode = DefineProperty<PostgreSqlMigrationMode>("MigrationMode", ["properties", "migrationMode"]);
        _migrationWindowEndTimeInUtc = DefineProperty<DateTimeOffset>("MigrationWindowEndTimeInUtc", ["properties", "migrationWindowEndTimeInUtc"]);
        _migrationWindowStartTimeInUtc = DefineProperty<DateTimeOffset>("MigrationWindowStartTimeInUtc", ["properties", "migrationWindowStartTimeInUtc"]);
        _overwriteDbsInTarget = DefineProperty<PostgreSqlMigrationOverwriteDbsInTarget>("OverwriteDbsInTarget", ["properties", "overwriteDbsInTarget"]);
        _secretParameters = DefineModelProperty<PostgreSqlMigrationSecretParameters>("SecretParameters", ["properties", "secretParameters"]);
        _setupLogicalReplicationOnSourceDbIfNeeded = DefineProperty<PostgreSqlMigrationLogicalReplicationOnSourceDb>("SetupLogicalReplicationOnSourceDbIfNeeded", ["properties", "setupLogicalReplicationOnSourceDbIfNeeded"]);
        _sourceDbServerFullyQualifiedDomainName = DefineProperty<string>("SourceDbServerFullyQualifiedDomainName", ["properties", "sourceDbServerFullyQualifiedDomainName"]);
        _sourceDbServerResourceId = DefineProperty<ResourceIdentifier>("SourceDbServerResourceId", ["properties", "sourceDbServerResourceId"]);
        _startDataMigration = DefineProperty<PostgreSqlMigrationStartDataMigration>("StartDataMigration", ["properties", "startDataMigration"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _targetDbServerFullyQualifiedDomainName = DefineProperty<string>("TargetDbServerFullyQualifiedDomainName", ["properties", "targetDbServerFullyQualifiedDomainName"]);
        _triggerCutover = DefineProperty<PostgreSqlMigrationTriggerCutover>("TriggerCutover", ["properties", "triggerCutover"]);
        _currentStatus = DefineModelProperty<PostgreSqlMigrationStatus>("CurrentStatus", ["properties", "currentStatus"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _migrationId = DefineProperty<string>("MigrationId", ["properties", "migrationId"], isOutput: true);
        _sourceDbServerMetadata = DefineModelProperty<PostgreSqlServerMetadata>("SourceDbServerMetadata", ["properties", "sourceDbServerMetadata"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _targetDbServerMetadata = DefineModelProperty<PostgreSqlServerMetadata>("TargetDbServerMetadata", ["properties", "targetDbServerMetadata"], isOutput: true);
        _targetDbServerResourceId = DefineProperty<ResourceIdentifier>("TargetDbServerResourceId", ["properties", "targetDbServerResourceId"], isOutput: true);
        _parent = DefineResource<PostgreSqlFlexibleServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported PostgreSqlMigration resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-08-01.
        /// </summary>
        public static readonly string V2024_08_01 = "2024-08-01";

        /// <summary>
        /// 2022-12-01.
        /// </summary>
        public static readonly string V2022_12_01 = "2022-12-01";

        /// <summary>
        /// 2021-06-01.
        /// </summary>
        public static readonly string V2021_06_01 = "2021-06-01";
    }

    /// <summary>
    /// Creates a reference to an existing PostgreSqlMigration.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlMigration resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlMigration.</param>
    /// <returns>The existing PostgreSqlMigration resource.</returns>
    public static PostgreSqlMigration FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
