// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// PostgreSqlFlexibleServerActiveDirectoryAdministrator.
/// </summary>
public partial class PostgreSqlFlexibleServerActiveDirectoryAdministrator : ProvisionableResource
{
    /// <summary>
    /// Gets or sets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Guid of the objectId for the administrator.
    /// </summary>
    public BicepValue<string> ObjectId 
    {
        get { Initialize(); return _objectId!; }
    }
    private BicepValue<string>? _objectId;

    /// <summary>
    /// Active Directory administrator principal name.
    /// </summary>
    public BicepValue<string> PrincipalName 
    {
        get { Initialize(); return _principalName!; }
        set { Initialize(); _principalName!.Assign(value); }
    }
    private BicepValue<string>? _principalName;

    /// <summary>
    /// The principal type used to represent the type of Active Directory
    /// Administrator.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerPrincipalType> PrincipalType 
    {
        get { Initialize(); return _principalType!; }
        set { Initialize(); _principalType!.Assign(value); }
    }
    private BicepValue<PostgreSqlFlexibleServerPrincipalType>? _principalType;

    /// <summary>
    /// The tenantId of the Active Directory administrator.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
        set { Initialize(); _tenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent PostgreSqlFlexibleServer.
    /// </summary>
    public PostgreSqlFlexibleServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<PostgreSqlFlexibleServer>? _parent;

    /// <summary>
    /// Creates a new PostgreSqlFlexibleServerActiveDirectoryAdministrator.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// PostgreSqlFlexibleServerActiveDirectoryAdministrator resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlFlexibleServerActiveDirectoryAdministrator.</param>
    public PostgreSqlFlexibleServerActiveDirectoryAdministrator(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.DBforPostgreSQL/flexibleServers/administrators", resourceVersion ?? "2024-08-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlFlexibleServerActiveDirectoryAdministrator.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _objectId = DefineProperty<string>("ObjectId", ["properties", "objectId"], isOutput: true);
        _principalName = DefineProperty<string>("PrincipalName", ["properties", "principalName"]);
        _principalType = DefineProperty<PostgreSqlFlexibleServerPrincipalType>("PrincipalType", ["properties", "principalType"]);
        _tenantId = DefineProperty<Guid>("TenantId", ["properties", "tenantId"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<PostgreSqlFlexibleServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported PostgreSqlFlexibleServerActiveDirectoryAdministrator resource
    /// versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-08-01.
        /// </summary>
        public static readonly string V2024_08_01 = "2024-08-01";

        /// <summary>
        /// 2022-12-01.
        /// </summary>
        public static readonly string V2022_12_01 = "2022-12-01";

        /// <summary>
        /// 2021-06-01.
        /// </summary>
        public static readonly string V2021_06_01 = "2021-06-01";
    }

    /// <summary>
    /// Creates a reference to an existing
    /// PostgreSqlFlexibleServerActiveDirectoryAdministrator.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// PostgreSqlFlexibleServerActiveDirectoryAdministrator resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlFlexibleServerActiveDirectoryAdministrator.</param>
    /// <returns>The existing PostgreSqlFlexibleServerActiveDirectoryAdministrator resource.</returns>
    public static PostgreSqlFlexibleServerActiveDirectoryAdministrator FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
