// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// PostgreSqlFlexibleServer.
/// </summary>
public partial class PostgreSqlFlexibleServer : ProvisionableResource
{
    /// <summary>
    /// The name of the server.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// The administrator&apos;s login name of a server. Can only be specified
    /// when the server is being created (and is required for creation).
    /// </summary>
    public BicepValue<string> AdministratorLogin 
    {
        get { Initialize(); return _administratorLogin!; }
        set { Initialize(); _administratorLogin!.Assign(value); }
    }
    private BicepValue<string>? _administratorLogin;

    /// <summary>
    /// The administrator login password (required for server creation).
    /// </summary>
    public BicepValue<string> AdministratorLoginPassword 
    {
        get { Initialize(); return _administratorLoginPassword!; }
        set { Initialize(); _administratorLoginPassword!.Assign(value); }
    }
    private BicepValue<string>? _administratorLoginPassword;

    /// <summary>
    /// AuthConfig properties of a server.
    /// </summary>
    public PostgreSqlFlexibleServerAuthConfig AuthConfig 
    {
        get { Initialize(); return _authConfig!; }
        set { Initialize(); AssignOrReplace(ref _authConfig, value); }
    }
    private PostgreSqlFlexibleServerAuthConfig? _authConfig;

    /// <summary>
    /// availability zone information of the server.
    /// </summary>
    public BicepValue<string> AvailabilityZone 
    {
        get { Initialize(); return _availabilityZone!; }
        set { Initialize(); _availabilityZone!.Assign(value); }
    }
    private BicepValue<string>? _availabilityZone;

    /// <summary>
    /// Backup properties of a server.
    /// </summary>
    public PostgreSqlFlexibleServerBackupProperties Backup 
    {
        get { Initialize(); return _backup!; }
        set { Initialize(); AssignOrReplace(ref _backup, value); }
    }
    private PostgreSqlFlexibleServerBackupProperties? _backup;

    /// <summary>
    /// The mode to create a new PostgreSQL server.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerCreateMode> CreateMode 
    {
        get { Initialize(); return _createMode!; }
        set { Initialize(); _createMode!.Assign(value); }
    }
    private BicepValue<PostgreSqlFlexibleServerCreateMode>? _createMode;

    /// <summary>
    /// Data encryption properties of a server.
    /// </summary>
    public PostgreSqlFlexibleServerDataEncryption DataEncryption 
    {
        get { Initialize(); return _dataEncryption!; }
        set { Initialize(); AssignOrReplace(ref _dataEncryption, value); }
    }
    private PostgreSqlFlexibleServerDataEncryption? _dataEncryption;

    /// <summary>
    /// High availability properties of a server.
    /// </summary>
    public PostgreSqlFlexibleServerHighAvailability HighAvailability 
    {
        get { Initialize(); return _highAvailability!; }
        set { Initialize(); AssignOrReplace(ref _highAvailability, value); }
    }
    private PostgreSqlFlexibleServerHighAvailability? _highAvailability;

    /// <summary>
    /// Describes the identity of the application.
    /// </summary>
    public PostgreSqlFlexibleServerUserAssignedIdentity Identity 
    {
        get { Initialize(); return _identity!; }
        set { Initialize(); AssignOrReplace(ref _identity, value); }
    }
    private PostgreSqlFlexibleServerUserAssignedIdentity? _identity;

    /// <summary>
    /// Maintenance window properties of a server.
    /// </summary>
    public PostgreSqlFlexibleServerMaintenanceWindow MaintenanceWindow 
    {
        get { Initialize(); return _maintenanceWindow!; }
        set { Initialize(); AssignOrReplace(ref _maintenanceWindow, value); }
    }
    private PostgreSqlFlexibleServerMaintenanceWindow? _maintenanceWindow;

    /// <summary>
    /// Network properties of a server. This Network property is required to be
    /// passed only in case you want the server to be Private access server.
    /// </summary>
    public PostgreSqlFlexibleServerNetwork Network 
    {
        get { Initialize(); return _network!; }
        set { Initialize(); AssignOrReplace(ref _network, value); }
    }
    private PostgreSqlFlexibleServerNetwork? _network;

    /// <summary>
    /// Restore point creation time (ISO8601 format), specifying the time to
    /// restore from. It&apos;s required when &apos;createMode&apos; is
    /// &apos;PointInTimeRestore&apos; or &apos;GeoRestore&apos; or
    /// &apos;ReviveDropped&apos;.
    /// </summary>
    public BicepValue<DateTimeOffset> PointInTimeUtc 
    {
        get { Initialize(); return _pointInTimeUtc!; }
        set { Initialize(); _pointInTimeUtc!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _pointInTimeUtc;

    /// <summary>
    /// Replicas allowed for a server.
    /// </summary>
    public BicepValue<int> ReplicaCapacity 
    {
        get { Initialize(); return _replicaCapacity!; }
        set { Initialize(); _replicaCapacity!.Assign(value); }
    }
    private BicepValue<int>? _replicaCapacity;

    /// <summary>
    /// Replication role of the server.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerReplicationRole> ReplicationRole 
    {
        get { Initialize(); return _replicationRole!; }
        set { Initialize(); _replicationRole!.Assign(value); }
    }
    private BicepValue<PostgreSqlFlexibleServerReplicationRole>? _replicationRole;

    /// <summary>
    /// The SKU (pricing tier) of the server.
    /// </summary>
    public PostgreSqlFlexibleServerSku Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private PostgreSqlFlexibleServerSku? _sku;

    /// <summary>
    /// The source server resource ID to restore from. It&apos;s required when
    /// &apos;createMode&apos; is &apos;PointInTimeRestore&apos; or
    /// &apos;GeoRestore&apos; or &apos;Replica&apos; or
    /// &apos;ReviveDropped&apos;. This property is returned only for Replica
    /// server.
    /// </summary>
    public BicepValue<ResourceIdentifier> SourceServerResourceId 
    {
        get { Initialize(); return _sourceServerResourceId!; }
        set { Initialize(); _sourceServerResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _sourceServerResourceId;

    /// <summary>
    /// Storage properties of a server.
    /// </summary>
    public PostgreSqlFlexibleServerStorage Storage 
    {
        get { Initialize(); return _storage!; }
        set { Initialize(); AssignOrReplace(ref _storage, value); }
    }
    private PostgreSqlFlexibleServerStorage? _storage;

    /// <summary>
    /// Max storage allowed for a server.
    /// </summary>
    public BicepValue<int> StorageSizeInGB 
    {
        get { Initialize(); return _storageSizeInGB!; }
        set { Initialize(); _storageSizeInGB!.Assign(value); }
    }
    private BicepValue<int>? _storageSizeInGB;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// PostgreSQL Server version.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerVersion> Version 
    {
        get { Initialize(); return _version!; }
        set { Initialize(); _version!.Assign(value); }
    }
    private BicepValue<PostgreSqlFlexibleServerVersion>? _version;

    /// <summary>
    /// The fully qualified domain name of a server.
    /// </summary>
    public BicepValue<string> FullyQualifiedDomainName 
    {
        get { Initialize(); return _fullyQualifiedDomainName!; }
    }
    private BicepValue<string>? _fullyQualifiedDomainName;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The minor version of the server.
    /// </summary>
    public BicepValue<string> MinorVersion 
    {
        get { Initialize(); return _minorVersion!; }
    }
    private BicepValue<string>? _minorVersion;

    /// <summary>
    /// A state of a server that is visible to user.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerState> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<PostgreSqlFlexibleServerState>? _state;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new PostgreSqlFlexibleServer.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlFlexibleServer resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlFlexibleServer.</param>
    public PostgreSqlFlexibleServer(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.DBforPostgreSQL/flexibleServers", resourceVersion ?? "2024-08-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PostgreSqlFlexibleServer.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _administratorLogin = DefineProperty<string>("AdministratorLogin", ["properties", "administratorLogin"]);
        _administratorLoginPassword = DefineProperty<string>("AdministratorLoginPassword", ["properties", "administratorLoginPassword"]);
        _authConfig = DefineModelProperty<PostgreSqlFlexibleServerAuthConfig>("AuthConfig", ["properties", "authConfig"]);
        _availabilityZone = DefineProperty<string>("AvailabilityZone", ["properties", "availabilityZone"]);
        _backup = DefineModelProperty<PostgreSqlFlexibleServerBackupProperties>("Backup", ["properties", "backup"]);
        _createMode = DefineProperty<PostgreSqlFlexibleServerCreateMode>("CreateMode", ["properties", "createMode"]);
        _dataEncryption = DefineModelProperty<PostgreSqlFlexibleServerDataEncryption>("DataEncryption", ["properties", "dataEncryption"]);
        _highAvailability = DefineModelProperty<PostgreSqlFlexibleServerHighAvailability>("HighAvailability", ["properties", "highAvailability"]);
        _identity = DefineModelProperty<PostgreSqlFlexibleServerUserAssignedIdentity>("Identity", ["identity"]);
        _maintenanceWindow = DefineModelProperty<PostgreSqlFlexibleServerMaintenanceWindow>("MaintenanceWindow", ["properties", "maintenanceWindow"]);
        _network = DefineModelProperty<PostgreSqlFlexibleServerNetwork>("Network", ["properties", "network"]);
        _pointInTimeUtc = DefineProperty<DateTimeOffset>("PointInTimeUtc", ["properties", "pointInTimeUTC"]);
        _replicaCapacity = DefineProperty<int>("ReplicaCapacity", ["properties", "replicaCapacity"]);
        _replicationRole = DefineProperty<PostgreSqlFlexibleServerReplicationRole>("ReplicationRole", ["properties", "replicationRole"]);
        _sku = DefineModelProperty<PostgreSqlFlexibleServerSku>("Sku", ["sku"]);
        _sourceServerResourceId = DefineProperty<ResourceIdentifier>("SourceServerResourceId", ["properties", "sourceServerResourceId"]);
        _storage = DefineModelProperty<PostgreSqlFlexibleServerStorage>("Storage", ["properties", "storage"]);
        _storageSizeInGB = DefineProperty<int>("StorageSizeInGB", ["properties", "storage", "storageSizeGB"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _version = DefineProperty<PostgreSqlFlexibleServerVersion>("Version", ["properties", "version"]);
        _fullyQualifiedDomainName = DefineProperty<string>("FullyQualifiedDomainName", ["properties", "fullyQualifiedDomainName"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _minorVersion = DefineProperty<string>("MinorVersion", ["properties", "minorVersion"], isOutput: true);
        _state = DefineProperty<PostgreSqlFlexibleServerState>("State", ["properties", "state"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported PostgreSqlFlexibleServer resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-08-01.
        /// </summary>
        public static readonly string V2024_08_01 = "2024-08-01";

        /// <summary>
        /// 2022-12-01.
        /// </summary>
        public static readonly string V2022_12_01 = "2022-12-01";

        /// <summary>
        /// 2021-06-01.
        /// </summary>
        public static readonly string V2021_06_01 = "2021-06-01";
    }

    /// <summary>
    /// Creates a reference to an existing PostgreSqlFlexibleServer.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlFlexibleServer resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlFlexibleServer.</param>
    /// <returns>The existing PostgreSqlFlexibleServer resource.</returns>
    public static PostgreSqlFlexibleServer FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this PostgreSqlFlexibleServer resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 3, maxLength: 63, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);
}
