// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// PostgreSqlDatabase.
/// </summary>
public partial class PostgreSqlDatabase : ProvisionableResource
{
    /// <summary>
    /// The name of the database.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The charset of the database.
    /// </summary>
    public BicepValue<string> Charset 
    {
        get { Initialize(); return _charset!; }
        set { Initialize(); _charset!.Assign(value); }
    }
    private BicepValue<string>? _charset;

    /// <summary>
    /// The collation of the database.
    /// </summary>
    public BicepValue<string> Collation 
    {
        get { Initialize(); return _collation!; }
        set { Initialize(); _collation!.Assign(value); }
    }
    private BicepValue<string>? _collation;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent PostgreSqlServer.
    /// </summary>
    public PostgreSqlServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<PostgreSqlServer>? _parent;

    /// <summary>
    /// Creates a new PostgreSqlDatabase.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlDatabase resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlDatabase.</param>
    public PostgreSqlDatabase(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.DBforPostgreSQL/servers/databases", resourceVersion ?? "2017-12-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PostgreSqlDatabase.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _charset = DefineProperty<string>("Charset", ["properties", "charset"]);
        _collation = DefineProperty<string>("Collation", ["properties", "collation"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<PostgreSqlServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported PostgreSqlDatabase resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2017-12-01.
        /// </summary>
        public static readonly string V2017_12_01 = "2017-12-01";
    }

    /// <summary>
    /// Creates a reference to an existing PostgreSqlDatabase.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlDatabase resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlDatabase.</param>
    /// <returns>The existing PostgreSqlDatabase resource.</returns>
    public static PostgreSqlDatabase FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this PostgreSqlDatabase resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 63, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);
}
