// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// PostgreSqlConfiguration.
/// </summary>
public partial class PostgreSqlConfiguration : ProvisionableResource
{
    /// <summary>
    /// The name of the server configuration.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Source of the configuration.
    /// </summary>
    public BicepValue<string> Source 
    {
        get { Initialize(); return _source!; }
        set { Initialize(); _source!.Assign(value); }
    }
    private BicepValue<string>? _source;

    /// <summary>
    /// Value of the configuration.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Allowed values of the configuration.
    /// </summary>
    public BicepValue<string> AllowedValues 
    {
        get { Initialize(); return _allowedValues!; }
    }
    private BicepValue<string>? _allowedValues;

    /// <summary>
    /// Data type of the configuration.
    /// </summary>
    public BicepValue<string> DataType 
    {
        get { Initialize(); return _dataType!; }
    }
    private BicepValue<string>? _dataType;

    /// <summary>
    /// Default value of the configuration.
    /// </summary>
    public BicepValue<string> DefaultValue 
    {
        get { Initialize(); return _defaultValue!; }
    }
    private BicepValue<string>? _defaultValue;

    /// <summary>
    /// Description of the configuration.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent PostgreSqlServer.
    /// </summary>
    public PostgreSqlServer? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<PostgreSqlServer>? _parent;

    /// <summary>
    /// Creates a new PostgreSqlConfiguration.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlConfiguration resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlConfiguration.</param>
    public PostgreSqlConfiguration(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.DBforPostgreSQL/servers/configurations", resourceVersion ?? "2017-12-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PostgreSqlConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _source = DefineProperty<string>("Source", ["properties", "source"]);
        _value = DefineProperty<string>("Value", ["properties", "value"]);
        _allowedValues = DefineProperty<string>("AllowedValues", ["properties", "allowedValues"], isOutput: true);
        _dataType = DefineProperty<string>("DataType", ["properties", "dataType"], isOutput: true);
        _defaultValue = DefineProperty<string>("DefaultValue", ["properties", "defaultValue"], isOutput: true);
        _description = DefineProperty<string>("Description", ["properties", "description"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<PostgreSqlServer>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported PostgreSqlConfiguration resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2017-12-01.
        /// </summary>
        public static readonly string V2017_12_01 = "2017-12-01";
    }

    /// <summary>
    /// Creates a reference to an existing PostgreSqlConfiguration.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the PostgreSqlConfiguration resource.
    /// This can be used to refer to the resource in expressions, but is not
    /// the Azure name of the resource.  This value can contain letters,
    /// numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the PostgreSqlConfiguration.</param>
    /// <returns>The existing PostgreSqlConfiguration resource.</returns>
    public static PostgreSqlConfiguration FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
