// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// Sku information related properties of a server.
/// </summary>
public partial class ServerSku : ProvisionableConstruct
{
    /// <summary>
    /// The name of the sku, typically, tier + family + cores, e.g.
    /// Standard_D4s_v3.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The tier of the particular SKU, e.g. Burstable.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerSkuTier> Tier 
    {
        get { Initialize(); return _tier!; }
    }
    private BicepValue<PostgreSqlFlexibleServerSkuTier>? _tier;

    /// <summary>
    /// Creates a new ServerSku.
    /// </summary>
    public ServerSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ServerSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _tier = DefineProperty<PostgreSqlFlexibleServerSkuTier>("Tier", ["tier"], isOutput: true);
    }
}
