// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// Billing information related properties of a server.
/// </summary>
public partial class PostgreSqlSku : ProvisionableConstruct
{
    /// <summary>
    /// The name of the sku, typically, tier + family + cores, e.g. B_Gen4_1,
    /// GP_Gen5_8.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The tier of the particular SKU, e.g. Basic.
    /// </summary>
    public BicepValue<PostgreSqlSkuTier> Tier 
    {
        get { Initialize(); return _tier!; }
        set { Initialize(); _tier!.Assign(value); }
    }
    private BicepValue<PostgreSqlSkuTier>? _tier;

    /// <summary>
    /// The scale up/out capacity, representing server&apos;s compute units.
    /// </summary>
    public BicepValue<int> Capacity 
    {
        get { Initialize(); return _capacity!; }
        set { Initialize(); _capacity!.Assign(value); }
    }
    private BicepValue<int>? _capacity;

    /// <summary>
    /// The size code, to be interpreted by resource as appropriate.
    /// </summary>
    public BicepValue<string> Size 
    {
        get { Initialize(); return _size!; }
        set { Initialize(); _size!.Assign(value); }
    }
    private BicepValue<string>? _size;

    /// <summary>
    /// The family of hardware.
    /// </summary>
    public BicepValue<string> Family 
    {
        get { Initialize(); return _family!; }
        set { Initialize(); _family!.Assign(value); }
    }
    private BicepValue<string>? _family;

    /// <summary>
    /// Creates a new PostgreSqlSku.
    /// </summary>
    public PostgreSqlSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PostgreSqlSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _tier = DefineProperty<PostgreSqlSkuTier>("Tier", ["tier"]);
        _capacity = DefineProperty<int>("Capacity", ["capacity"]);
        _size = DefineProperty<string>("Size", ["size"]);
        _family = DefineProperty<string>("Family", ["family"]);
    }
}
