// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// The properties used to create a new server by restoring from a backup.
/// </summary>
public partial class PostgreSqlServerPropertiesForRestore : PostgreSqlServerPropertiesForCreate
{
    /// <summary>
    /// The source server id to restore from.
    /// </summary>
    public BicepValue<ResourceIdentifier> SourceServerId 
    {
        get { Initialize(); return _sourceServerId!; }
    }
    private BicepValue<ResourceIdentifier>? _sourceServerId;

    /// <summary>
    /// Restore point creation time (ISO8601 format), specifying the time to
    /// restore from.
    /// </summary>
    public BicepValue<DateTimeOffset> RestorePointInTime 
    {
        get { Initialize(); return _restorePointInTime!; }
    }
    private BicepValue<DateTimeOffset>? _restorePointInTime;

    /// <summary>
    /// Creates a new PostgreSqlServerPropertiesForRestore.
    /// </summary>
    public PostgreSqlServerPropertiesForRestore() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlServerPropertiesForRestore.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("createMode", ["createMode"], defaultValue: "PointInTimeRestore");
        _sourceServerId = DefineProperty<ResourceIdentifier>("SourceServerId", ["sourceServerId"], isOutput: true);
        _restorePointInTime = DefineProperty<DateTimeOffset>("RestorePointInTime", ["restorePointInTime"], isOutput: true);
    }
}
