// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// The properties to create a new replica.
/// </summary>
public partial class PostgreSqlServerPropertiesForReplica : PostgreSqlServerPropertiesForCreate
{
    /// <summary>
    /// The master server id to create replica from.
    /// </summary>
    public BicepValue<ResourceIdentifier> SourceServerId 
    {
        get { Initialize(); return _sourceServerId!; }
    }
    private BicepValue<ResourceIdentifier>? _sourceServerId;

    /// <summary>
    /// Creates a new PostgreSqlServerPropertiesForReplica.
    /// </summary>
    public PostgreSqlServerPropertiesForReplica() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlServerPropertiesForReplica.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("createMode", ["createMode"], defaultValue: "Replica");
        _sourceServerId = DefineProperty<ResourceIdentifier>("SourceServerId", ["sourceServerId"], isOutput: true);
    }
}
