// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// The properties used to create a new server by restoring to a different
/// region from a geo replicated backup.
/// </summary>
public partial class PostgreSqlServerPropertiesForGeoRestore : PostgreSqlServerPropertiesForCreate
{
    /// <summary>
    /// The source server id to restore from.
    /// </summary>
    public BicepValue<ResourceIdentifier> SourceServerId 
    {
        get { Initialize(); return _sourceServerId!; }
    }
    private BicepValue<ResourceIdentifier>? _sourceServerId;

    /// <summary>
    /// Creates a new PostgreSqlServerPropertiesForGeoRestore.
    /// </summary>
    public PostgreSqlServerPropertiesForGeoRestore() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlServerPropertiesForGeoRestore.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("createMode", ["createMode"], defaultValue: "GeoRestore");
        _sourceServerId = DefineProperty<ResourceIdentifier>("SourceServerId", ["sourceServerId"], isOutput: true);
    }
}
