// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// The properties used to create a new server.
/// </summary>
public partial class PostgreSqlServerPropertiesForDefaultCreate : PostgreSqlServerPropertiesForCreate
{
    /// <summary>
    /// The administrator&apos;s login name of a server. Can only be specified
    /// when the server is being created (and is required for creation).
    /// </summary>
    public BicepValue<string> AdministratorLogin 
    {
        get { Initialize(); return _administratorLogin!; }
    }
    private BicepValue<string>? _administratorLogin;

    /// <summary>
    /// The password of the administrator login.
    /// </summary>
    public BicepValue<string> AdministratorLoginPassword 
    {
        get { Initialize(); return _administratorLoginPassword!; }
    }
    private BicepValue<string>? _administratorLoginPassword;

    /// <summary>
    /// Creates a new PostgreSqlServerPropertiesForDefaultCreate.
    /// </summary>
    public PostgreSqlServerPropertiesForDefaultCreate() : base()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlServerPropertiesForDefaultCreate.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        DefineProperty<string>("createMode", ["createMode"], defaultValue: "Default");
        _administratorLogin = DefineProperty<string>("AdministratorLogin", ["administratorLogin"], isOutput: true);
        _administratorLoginPassword = DefineProperty<string>("AdministratorLoginPassword", ["administratorLoginPassword"], isOutput: true);
    }
}
