// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// The properties used to create a new server.             Please note
/// Azure.ResourceManager.PostgreSql.Models.PostgreSqlServerPropertiesForCreate
/// is the base class. According to the scenario, a derived class of the base
/// class might need to be assigned here, or this property needs to be casted
/// to one of the possible derived classes.             The available derived
/// classes include
/// Azure.ResourceManager.PostgreSql.Models.PostgreSqlServerPropertiesForDefaultCreate,
/// Azure.ResourceManager.PostgreSql.Models.PostgreSqlServerPropertiesForGeoRestore,
/// Azure.ResourceManager.PostgreSql.Models.PostgreSqlServerPropertiesForRestore
/// and
/// Azure.ResourceManager.PostgreSql.Models.PostgreSqlServerPropertiesForReplica.
/// </summary>
public partial class PostgreSqlServerPropertiesForCreate : ProvisionableConstruct
{
    /// <summary>
    /// Server version.
    /// </summary>
    public BicepValue<PostgreSqlServerVersion> Version 
    {
        get { Initialize(); return _version!; }
        set { Initialize(); _version!.Assign(value); }
    }
    private BicepValue<PostgreSqlServerVersion>? _version;

    /// <summary>
    /// Enable ssl enforcement or not when connect to server.
    /// </summary>
    public BicepValue<PostgreSqlSslEnforcementEnum> SslEnforcement 
    {
        get { Initialize(); return _sslEnforcement!; }
        set { Initialize(); _sslEnforcement!.Assign(value); }
    }
    private BicepValue<PostgreSqlSslEnforcementEnum>? _sslEnforcement;

    /// <summary>
    /// Enforce a minimal Tls version for the server.
    /// </summary>
    public BicepValue<PostgreSqlMinimalTlsVersionEnum> MinimalTlsVersion 
    {
        get { Initialize(); return _minimalTlsVersion!; }
        set { Initialize(); _minimalTlsVersion!.Assign(value); }
    }
    private BicepValue<PostgreSqlMinimalTlsVersionEnum>? _minimalTlsVersion;

    /// <summary>
    /// Status showing whether the server enabled infrastructure encryption.
    /// </summary>
    public BicepValue<PostgreSqlInfrastructureEncryption> InfrastructureEncryption 
    {
        get { Initialize(); return _infrastructureEncryption!; }
        set { Initialize(); _infrastructureEncryption!.Assign(value); }
    }
    private BicepValue<PostgreSqlInfrastructureEncryption>? _infrastructureEncryption;

    /// <summary>
    /// Whether or not public network access is allowed for this server. Value
    /// is optional but if passed in, must be &apos;Enabled&apos; or
    /// &apos;Disabled&apos;.
    /// </summary>
    public BicepValue<PostgreSqlPublicNetworkAccessEnum> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<PostgreSqlPublicNetworkAccessEnum>? _publicNetworkAccess;

    /// <summary>
    /// Storage profile of a server.
    /// </summary>
    public PostgreSqlStorageProfile StorageProfile 
    {
        get { Initialize(); return _storageProfile!; }
        set { Initialize(); AssignOrReplace(ref _storageProfile, value); }
    }
    private PostgreSqlStorageProfile? _storageProfile;

    /// <summary>
    /// Creates a new PostgreSqlServerPropertiesForCreate.
    /// </summary>
    public PostgreSqlServerPropertiesForCreate()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlServerPropertiesForCreate.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _version = DefineProperty<PostgreSqlServerVersion>("Version", ["version"]);
        _sslEnforcement = DefineProperty<PostgreSqlSslEnforcementEnum>("SslEnforcement", ["sslEnforcement"]);
        _minimalTlsVersion = DefineProperty<PostgreSqlMinimalTlsVersionEnum>("MinimalTlsVersion", ["minimalTlsVersion"]);
        _infrastructureEncryption = DefineProperty<PostgreSqlInfrastructureEncryption>("InfrastructureEncryption", ["infrastructureEncryption"]);
        _publicNetworkAccess = DefineProperty<PostgreSqlPublicNetworkAccessEnum>("PublicNetworkAccess", ["publicNetworkAccess"]);
        _storageProfile = DefineModelProperty<PostgreSqlStorageProfile>("StorageProfile", ["storageProfile"]);
    }
}
