// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// Database server metadata.
/// </summary>
public partial class PostgreSqlServerMetadata : ProvisionableConstruct
{
    /// <summary>
    /// Location of database server.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Version for database engine.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Storage size in MB for database server.
    /// </summary>
    public BicepValue<int> StorageMb 
    {
        get { Initialize(); return _storageMb!; }
    }
    private BicepValue<int>? _storageMb;

    /// <summary>
    /// SKU for the database server.
    /// </summary>
    public ServerSku Sku 
    {
        get { Initialize(); return _sku!; }
    }
    private ServerSku? _sku;

    /// <summary>
    /// Creates a new PostgreSqlServerMetadata.
    /// </summary>
    public PostgreSqlServerMetadata()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PostgreSqlServerMetadata.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _version = DefineProperty<string>("Version", ["version"], isOutput: true);
        _storageMb = DefineProperty<int>("StorageMb", ["storageMb"], isOutput: true);
        _sku = DefineModelProperty<ServerSku>("Sku", ["sku"], isOutput: true);
    }
}
