// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// Migration status.
/// </summary>
public partial class PostgreSqlMigrationStatus : ProvisionableConstruct
{
    /// <summary>
    /// State of migration.
    /// </summary>
    public BicepValue<PostgreSqlMigrationState> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<PostgreSqlMigrationState>? _state;

    /// <summary>
    /// Error message, if any, for the migration state.
    /// </summary>
    public BicepValue<string> Error 
    {
        get { Initialize(); return _error!; }
    }
    private BicepValue<string>? _error;

    /// <summary>
    /// Migration sub state.
    /// </summary>
    public BicepValue<PostgreSqlMigrationSubState> CurrentSubState 
    {
        get { Initialize(); return _currentSubState!; }
    }
    private BicepValue<PostgreSqlMigrationSubState>? _currentSubState;

    /// <summary>
    /// Creates a new PostgreSqlMigrationStatus.
    /// </summary>
    public PostgreSqlMigrationStatus()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PostgreSqlMigrationStatus.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _state = DefineProperty<PostgreSqlMigrationState>("State", ["state"], isOutput: true);
        _error = DefineProperty<string>("Error", ["error"], isOutput: true);
        _currentSubState = DefineProperty<PostgreSqlMigrationSubState>("CurrentSubState", ["currentSubStateDetails", "currentSubState"], isOutput: true);
    }
}
