// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// Migration secret parameters.
/// </summary>
public partial class PostgreSqlMigrationSecretParameters : ProvisionableConstruct
{
    /// <summary>
    /// Admin credentials for source and target servers.
    /// </summary>
    public PostgreSqlMigrationAdminCredentials AdminCredentials 
    {
        get { Initialize(); return _adminCredentials!; }
        set { Initialize(); AssignOrReplace(ref _adminCredentials, value); }
    }
    private PostgreSqlMigrationAdminCredentials? _adminCredentials;

    /// <summary>
    /// Gets or sets the username for the source server. This user need not be
    /// an admin.
    /// </summary>
    public BicepValue<string> SourceServerUsername 
    {
        get { Initialize(); return _sourceServerUsername!; }
        set { Initialize(); _sourceServerUsername!.Assign(value); }
    }
    private BicepValue<string>? _sourceServerUsername;

    /// <summary>
    /// Gets or sets the username for the target server. This user need not be
    /// an admin.
    /// </summary>
    public BicepValue<string> TargetServerUsername 
    {
        get { Initialize(); return _targetServerUsername!; }
        set { Initialize(); _targetServerUsername!.Assign(value); }
    }
    private BicepValue<string>? _targetServerUsername;

    /// <summary>
    /// Creates a new PostgreSqlMigrationSecretParameters.
    /// </summary>
    public PostgreSqlMigrationSecretParameters()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlMigrationSecretParameters.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _adminCredentials = DefineModelProperty<PostgreSqlMigrationAdminCredentials>("AdminCredentials", ["adminCredentials"]);
        _sourceServerUsername = DefineProperty<string>("SourceServerUsername", ["sourceServerUsername"]);
        _targetServerUsername = DefineProperty<string>("TargetServerUsername", ["targetServerUsername"]);
    }
}
