// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// Information describing the identities associated with this application.
/// </summary>
public partial class PostgreSqlFlexibleServerUserAssignedIdentity : ProvisionableConstruct
{
    /// <summary>
    /// represents user assigned identities map.
    /// </summary>
    public BicepDictionary<UserAssignedIdentityDetails> UserAssignedIdentities 
    {
        get { Initialize(); return _userAssignedIdentities!; }
        set { Initialize(); _userAssignedIdentities!.Assign(value); }
    }
    private BicepDictionary<UserAssignedIdentityDetails>? _userAssignedIdentities;

    /// <summary>
    /// the types of identities associated with this resource; currently
    /// restricted to &apos;None and UserAssigned&apos;.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerIdentityType> IdentityType 
    {
        get { Initialize(); return _identityType!; }
        set { Initialize(); _identityType!.Assign(value); }
    }
    private BicepValue<PostgreSqlFlexibleServerIdentityType>? _identityType;

    /// <summary>
    /// Tenant id of the server.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Creates a new PostgreSqlFlexibleServerUserAssignedIdentity.
    /// </summary>
    public PostgreSqlFlexibleServerUserAssignedIdentity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlFlexibleServerUserAssignedIdentity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _userAssignedIdentities = DefineDictionaryProperty<UserAssignedIdentityDetails>("UserAssignedIdentities", ["userAssignedIdentities"]);
        _identityType = DefineProperty<PostgreSqlFlexibleServerIdentityType>("IdentityType", ["type"]);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"], isOutput: true);
    }
}
