// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// Network properties of a server.
/// </summary>
public partial class PostgreSqlFlexibleServerNetwork : ProvisionableConstruct
{
    /// <summary>
    /// public network access is enabled or not.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerPublicNetworkAccessState> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
    }
    private BicepValue<PostgreSqlFlexibleServerPublicNetworkAccessState>? _publicNetworkAccess;

    /// <summary>
    /// Delegated subnet arm resource id. This is required to be passed during
    /// create, in case we want the server to be VNET injected, i.e. Private
    /// access server. During update, pass this only if we want to update the
    /// value for Private DNS zone.
    /// </summary>
    public BicepValue<ResourceIdentifier> DelegatedSubnetResourceId 
    {
        get { Initialize(); return _delegatedSubnetResourceId!; }
        set { Initialize(); _delegatedSubnetResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _delegatedSubnetResourceId;

    /// <summary>
    /// Private dns zone arm resource id. This is required to be passed during
    /// create, in case we want the server to be VNET injected, i.e. Private
    /// access server. During update, pass this only if we want to update the
    /// value for Private DNS zone.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrivateDnsZoneArmResourceId 
    {
        get { Initialize(); return _privateDnsZoneArmResourceId!; }
        set { Initialize(); _privateDnsZoneArmResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _privateDnsZoneArmResourceId;

    /// <summary>
    /// Creates a new PostgreSqlFlexibleServerNetwork.
    /// </summary>
    public PostgreSqlFlexibleServerNetwork()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlFlexibleServerNetwork.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _publicNetworkAccess = DefineProperty<PostgreSqlFlexibleServerPublicNetworkAccessState>("PublicNetworkAccess", ["publicNetworkAccess"], isOutput: true);
        _delegatedSubnetResourceId = DefineProperty<ResourceIdentifier>("DelegatedSubnetResourceId", ["delegatedSubnetResourceId"]);
        _privateDnsZoneArmResourceId = DefineProperty<ResourceIdentifier>("PrivateDnsZoneArmResourceId", ["privateDnsZoneArmResourceId"]);
    }
}
