// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// Maintenance window properties of a server.
/// </summary>
public partial class PostgreSqlFlexibleServerMaintenanceWindow : ProvisionableConstruct
{
    /// <summary>
    /// indicates whether custom window is enabled or disabled.
    /// </summary>
    public BicepValue<string> CustomWindow 
    {
        get { Initialize(); return _customWindow!; }
        set { Initialize(); _customWindow!.Assign(value); }
    }
    private BicepValue<string>? _customWindow;

    /// <summary>
    /// start hour for maintenance window.
    /// </summary>
    public BicepValue<int> StartHour 
    {
        get { Initialize(); return _startHour!; }
        set { Initialize(); _startHour!.Assign(value); }
    }
    private BicepValue<int>? _startHour;

    /// <summary>
    /// start minute for maintenance window.
    /// </summary>
    public BicepValue<int> StartMinute 
    {
        get { Initialize(); return _startMinute!; }
        set { Initialize(); _startMinute!.Assign(value); }
    }
    private BicepValue<int>? _startMinute;

    /// <summary>
    /// day of week for maintenance window.
    /// </summary>
    public BicepValue<int> DayOfWeek 
    {
        get { Initialize(); return _dayOfWeek!; }
        set { Initialize(); _dayOfWeek!.Assign(value); }
    }
    private BicepValue<int>? _dayOfWeek;

    /// <summary>
    /// Creates a new PostgreSqlFlexibleServerMaintenanceWindow.
    /// </summary>
    public PostgreSqlFlexibleServerMaintenanceWindow()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlFlexibleServerMaintenanceWindow.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _customWindow = DefineProperty<string>("CustomWindow", ["customWindow"]);
        _startHour = DefineProperty<int>("StartHour", ["startHour"]);
        _startMinute = DefineProperty<int>("StartMinute", ["startMinute"]);
        _dayOfWeek = DefineProperty<int>("DayOfWeek", ["dayOfWeek"]);
    }
}
