// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// High availability properties of a server.
/// </summary>
public partial class PostgreSqlFlexibleServerHighAvailability : ProvisionableConstruct
{
    /// <summary>
    /// The HA mode for the server.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerHighAvailabilityMode> Mode 
    {
        get { Initialize(); return _mode!; }
        set { Initialize(); _mode!.Assign(value); }
    }
    private BicepValue<PostgreSqlFlexibleServerHighAvailabilityMode>? _mode;

    /// <summary>
    /// A state of a HA server that is visible to user.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerHAState> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<PostgreSqlFlexibleServerHAState>? _state;

    /// <summary>
    /// availability zone information of the standby.
    /// </summary>
    public BicepValue<string> StandbyAvailabilityZone 
    {
        get { Initialize(); return _standbyAvailabilityZone!; }
        set { Initialize(); _standbyAvailabilityZone!.Assign(value); }
    }
    private BicepValue<string>? _standbyAvailabilityZone;

    /// <summary>
    /// Creates a new PostgreSqlFlexibleServerHighAvailability.
    /// </summary>
    public PostgreSqlFlexibleServerHighAvailability()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlFlexibleServerHighAvailability.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _mode = DefineProperty<PostgreSqlFlexibleServerHighAvailabilityMode>("Mode", ["mode"]);
        _state = DefineProperty<PostgreSqlFlexibleServerHAState>("State", ["state"], isOutput: true);
        _standbyAvailabilityZone = DefineProperty<string>("StandbyAvailabilityZone", ["standbyAvailabilityZone"]);
    }
}
