// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// Data encryption properties of a server.
/// </summary>
public partial class PostgreSqlFlexibleServerDataEncryption : ProvisionableConstruct
{
    /// <summary>
    /// URI for the key in keyvault for data encryption of the primary server.
    /// </summary>
    public BicepValue<Uri> PrimaryKeyUri 
    {
        get { Initialize(); return _primaryKeyUri!; }
        set { Initialize(); _primaryKeyUri!.Assign(value); }
    }
    private BicepValue<Uri>? _primaryKeyUri;

    /// <summary>
    /// Resource Id for the User assigned identity to be used for data
    /// encryption of the primary server.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrimaryUserAssignedIdentityId 
    {
        get { Initialize(); return _primaryUserAssignedIdentityId!; }
        set { Initialize(); _primaryUserAssignedIdentityId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _primaryUserAssignedIdentityId;

    /// <summary>
    /// URI for the key in keyvault for data encryption for geo-backup of
    /// server.
    /// </summary>
    public BicepValue<Uri> GeoBackupKeyUri 
    {
        get { Initialize(); return _geoBackupKeyUri!; }
        set { Initialize(); _geoBackupKeyUri!.Assign(value); }
    }
    private BicepValue<Uri>? _geoBackupKeyUri;

    /// <summary>
    /// Resource Id for the User assigned identity to be used for data
    /// encryption for geo-backup of server.
    /// </summary>
    public BicepValue<string> GeoBackupUserAssignedIdentityId 
    {
        get { Initialize(); return _geoBackupUserAssignedIdentityId!; }
        set { Initialize(); _geoBackupUserAssignedIdentityId!.Assign(value); }
    }
    private BicepValue<string>? _geoBackupUserAssignedIdentityId;

    /// <summary>
    /// Data encryption type to depict if it is System Managed vs Azure Key
    /// vault.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerKeyType> KeyType 
    {
        get { Initialize(); return _keyType!; }
        set { Initialize(); _keyType!.Assign(value); }
    }
    private BicepValue<PostgreSqlFlexibleServerKeyType>? _keyType;

    /// <summary>
    /// Primary encryption key status for Data encryption enabled server.
    /// </summary>
    public BicepValue<PostgreSqlKeyStatus> PrimaryEncryptionKeyStatus 
    {
        get { Initialize(); return _primaryEncryptionKeyStatus!; }
        set { Initialize(); _primaryEncryptionKeyStatus!.Assign(value); }
    }
    private BicepValue<PostgreSqlKeyStatus>? _primaryEncryptionKeyStatus;

    /// <summary>
    /// Geo-backup encryption key status for Data encryption enabled server.
    /// </summary>
    public BicepValue<PostgreSqlKeyStatus> GeoBackupEncryptionKeyStatus 
    {
        get { Initialize(); return _geoBackupEncryptionKeyStatus!; }
        set { Initialize(); _geoBackupEncryptionKeyStatus!.Assign(value); }
    }
    private BicepValue<PostgreSqlKeyStatus>? _geoBackupEncryptionKeyStatus;

    /// <summary>
    /// Creates a new PostgreSqlFlexibleServerDataEncryption.
    /// </summary>
    public PostgreSqlFlexibleServerDataEncryption()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlFlexibleServerDataEncryption.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _primaryKeyUri = DefineProperty<Uri>("PrimaryKeyUri", ["primaryKeyURI"]);
        _primaryUserAssignedIdentityId = DefineProperty<ResourceIdentifier>("PrimaryUserAssignedIdentityId", ["primaryUserAssignedIdentityId"]);
        _geoBackupKeyUri = DefineProperty<Uri>("GeoBackupKeyUri", ["geoBackupKeyURI"]);
        _geoBackupUserAssignedIdentityId = DefineProperty<string>("GeoBackupUserAssignedIdentityId", ["geoBackupUserAssignedIdentityId"]);
        _keyType = DefineProperty<PostgreSqlFlexibleServerKeyType>("KeyType", ["type"]);
        _primaryEncryptionKeyStatus = DefineProperty<PostgreSqlKeyStatus>("PrimaryEncryptionKeyStatus", ["primaryEncryptionKeyStatus"]);
        _geoBackupEncryptionKeyStatus = DefineProperty<PostgreSqlKeyStatus>("GeoBackupEncryptionKeyStatus", ["geoBackupEncryptionKeyStatus"]);
    }
}
