// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// Backup properties of a server.
/// </summary>
public partial class PostgreSqlFlexibleServerBackupProperties : ProvisionableConstruct
{
    /// <summary>
    /// Backup retention days for the server.
    /// </summary>
    public BicepValue<int> BackupRetentionDays 
    {
        get { Initialize(); return _backupRetentionDays!; }
        set { Initialize(); _backupRetentionDays!.Assign(value); }
    }
    private BicepValue<int>? _backupRetentionDays;

    /// <summary>
    /// A value indicating whether Geo-Redundant backup is enabled on the
    /// server.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerGeoRedundantBackupEnum> GeoRedundantBackup 
    {
        get { Initialize(); return _geoRedundantBackup!; }
        set { Initialize(); _geoRedundantBackup!.Assign(value); }
    }
    private BicepValue<PostgreSqlFlexibleServerGeoRedundantBackupEnum>? _geoRedundantBackup;

    /// <summary>
    /// The earliest restore point time (ISO8601 format) for server.
    /// </summary>
    public BicepValue<DateTimeOffset> EarliestRestoreOn 
    {
        get { Initialize(); return _earliestRestoreOn!; }
    }
    private BicepValue<DateTimeOffset>? _earliestRestoreOn;

    /// <summary>
    /// Creates a new PostgreSqlFlexibleServerBackupProperties.
    /// </summary>
    public PostgreSqlFlexibleServerBackupProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlFlexibleServerBackupProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _backupRetentionDays = DefineProperty<int>("BackupRetentionDays", ["backupRetentionDays"]);
        _geoRedundantBackup = DefineProperty<PostgreSqlFlexibleServerGeoRedundantBackupEnum>("GeoRedundantBackup", ["geoRedundantBackup"]);
        _earliestRestoreOn = DefineProperty<DateTimeOffset>("EarliestRestoreOn", ["earliestRestoreDate"], isOutput: true);
    }
}
