// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.PostgreSql;

/// <summary>
/// Authentication configuration properties of a server.
/// </summary>
public partial class PostgreSqlFlexibleServerAuthConfig : ProvisionableConstruct
{
    /// <summary>
    /// If Enabled, Azure Active Directory authentication is enabled.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerActiveDirectoryAuthEnum> ActiveDirectoryAuth 
    {
        get { Initialize(); return _activeDirectoryAuth!; }
        set { Initialize(); _activeDirectoryAuth!.Assign(value); }
    }
    private BicepValue<PostgreSqlFlexibleServerActiveDirectoryAuthEnum>? _activeDirectoryAuth;

    /// <summary>
    /// If Enabled, Password authentication is enabled.
    /// </summary>
    public BicepValue<PostgreSqlFlexibleServerPasswordAuthEnum> PasswordAuth 
    {
        get { Initialize(); return _passwordAuth!; }
        set { Initialize(); _passwordAuth!.Assign(value); }
    }
    private BicepValue<PostgreSqlFlexibleServerPasswordAuthEnum>? _passwordAuth;

    /// <summary>
    /// Tenant id of the server.
    /// </summary>
    public BicepValue<Guid> TenantId 
    {
        get { Initialize(); return _tenantId!; }
        set { Initialize(); _tenantId!.Assign(value); }
    }
    private BicepValue<Guid>? _tenantId;

    /// <summary>
    /// Creates a new PostgreSqlFlexibleServerAuthConfig.
    /// </summary>
    public PostgreSqlFlexibleServerAuthConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// PostgreSqlFlexibleServerAuthConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _activeDirectoryAuth = DefineProperty<PostgreSqlFlexibleServerActiveDirectoryAuthEnum>("ActiveDirectoryAuth", ["activeDirectoryAuth"]);
        _passwordAuth = DefineProperty<PostgreSqlFlexibleServerPasswordAuthEnum>("PasswordAuth", ["passwordAuth"]);
        _tenantId = DefineProperty<Guid>("TenantId", ["tenantId"]);
    }
}
