// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// StorageInsight.
/// </summary>
public partial class StorageInsight : ProvisionableResource
{
    /// <summary>
    /// Name of the storageInsightsConfigs resource.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The names of the blob containers that the workspace should read.
    /// </summary>
    public BicepList<string> Containers 
    {
        get { Initialize(); return _containers!; }
        set { Initialize(); _containers!.Assign(value); }
    }
    private BicepList<string>? _containers;

    /// <summary>
    /// The ETag of the storage insight.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
        set { Initialize(); _eTag!.Assign(value); }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// The storage account connection details.
    /// </summary>
    public OperationalInsightsStorageAccount StorageAccount 
    {
        get { Initialize(); return _storageAccount!; }
        set { Initialize(); AssignOrReplace(ref _storageAccount, value); }
    }
    private OperationalInsightsStorageAccount? _storageAccount;

    /// <summary>
    /// The names of the Azure tables that the workspace should read.
    /// </summary>
    public BicepList<string> Tables 
    {
        get { Initialize(); return _tables!; }
        set { Initialize(); _tables!.Assign(value); }
    }
    private BicepList<string>? _tables;

    /// <summary>
    /// Resource tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The status of the storage insight.
    /// </summary>
    public StorageInsightStatus Status 
    {
        get { Initialize(); return _status!; }
    }
    private StorageInsightStatus? _status;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent OperationalInsightsWorkspace.
    /// </summary>
    public OperationalInsightsWorkspace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<OperationalInsightsWorkspace>? _parent;

    /// <summary>
    /// Creates a new StorageInsight.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the StorageInsight resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the StorageInsight.</param>
    public StorageInsight(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.OperationalInsights/workspaces/storageInsightConfigs", resourceVersion ?? "2023-09-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageInsight.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _containers = DefineListProperty<string>("Containers", ["properties", "containers"]);
        _eTag = DefineProperty<ETag>("ETag", ["eTag"]);
        _storageAccount = DefineModelProperty<OperationalInsightsStorageAccount>("StorageAccount", ["properties", "storageAccount"]);
        _tables = DefineListProperty<string>("Tables", ["properties", "tables"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _status = DefineModelProperty<StorageInsightStatus>("Status", ["properties", "status"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<OperationalInsightsWorkspace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported StorageInsight resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-09-01.
        /// </summary>
        public static readonly string V2023_09_01 = "2023-09-01";

        /// <summary>
        /// 2020-08-01.
        /// </summary>
        public static readonly string V2020_08_01 = "2020-08-01";

        /// <summary>
        /// 2015-03-20.
        /// </summary>
        public static readonly string V2015_03_20 = "2015-03-20";
    }

    /// <summary>
    /// Creates a reference to an existing StorageInsight.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the StorageInsight resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the StorageInsight.</param>
    /// <returns>The existing StorageInsight resource.</returns>
    public static StorageInsight FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
