// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// OperationalInsightsSavedSearch.
/// </summary>
public partial class OperationalInsightsSavedSearch : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The category of the saved search. This helps the user to find a saved
    /// search faster.
    /// </summary>
    public BicepValue<string> Category 
    {
        get { Initialize(); return _category!; }
        set { Initialize(); _category!.Assign(value); }
    }
    private BicepValue<string>? _category;

    /// <summary>
    /// Saved search display name.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
        set { Initialize(); _displayName!.Assign(value); }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// The query expression for the saved search.
    /// </summary>
    public BicepValue<string> Query 
    {
        get { Initialize(); return _query!; }
        set { Initialize(); _query!.Assign(value); }
    }
    private BicepValue<string>? _query;

    /// <summary>
    /// The ETag of the saved search. To override an existing saved search, use
    /// &quot;*&quot; or specify the current Etag.
    /// </summary>
    public BicepValue<ETag> ETag 
    {
        get { Initialize(); return _eTag!; }
        set { Initialize(); _eTag!.Assign(value); }
    }
    private BicepValue<ETag>? _eTag;

    /// <summary>
    /// The function alias if query serves as a function.
    /// </summary>
    public BicepValue<string> FunctionAlias 
    {
        get { Initialize(); return _functionAlias!; }
        set { Initialize(); _functionAlias!.Assign(value); }
    }
    private BicepValue<string>? _functionAlias;

    /// <summary>
    /// The optional function parameters if query serves as a function. Value
    /// should be in the following format: &apos;param-name1:type1 =
    /// default_value1, param-name2:type2 = default_value2&apos;. For more
    /// examples and proper syntax please refer to
    /// https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
    /// </summary>
    public BicepValue<string> FunctionParameters 
    {
        get { Initialize(); return _functionParameters!; }
        set { Initialize(); _functionParameters!.Assign(value); }
    }
    private BicepValue<string>? _functionParameters;

    /// <summary>
    /// The tags attached to the saved search.
    /// </summary>
    public BicepList<OperationalInsightsTag> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepList<OperationalInsightsTag>? _tags;

    /// <summary>
    /// The version number of the query language. The current version is 2 and
    /// is the default.
    /// </summary>
    public BicepValue<long> Version 
    {
        get { Initialize(); return _version!; }
        set { Initialize(); _version!.Assign(value); }
    }
    private BicepValue<long>? _version;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent OperationalInsightsWorkspace.
    /// </summary>
    public OperationalInsightsWorkspace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<OperationalInsightsWorkspace>? _parent;

    /// <summary>
    /// Creates a new OperationalInsightsSavedSearch.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the OperationalInsightsSavedSearch
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the OperationalInsightsSavedSearch.</param>
    public OperationalInsightsSavedSearch(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.OperationalInsights/workspaces/savedSearches", resourceVersion ?? "2023-09-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// OperationalInsightsSavedSearch.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _category = DefineProperty<string>("Category", ["properties", "category"], isRequired: true);
        _displayName = DefineProperty<string>("DisplayName", ["properties", "displayName"], isRequired: true);
        _query = DefineProperty<string>("Query", ["properties", "query"], isRequired: true);
        _eTag = DefineProperty<ETag>("ETag", ["etag"]);
        _functionAlias = DefineProperty<string>("FunctionAlias", ["properties", "functionAlias"]);
        _functionParameters = DefineProperty<string>("FunctionParameters", ["properties", "functionParameters"]);
        _tags = DefineListProperty<OperationalInsightsTag>("Tags", ["properties", "tags"]);
        _version = DefineProperty<long>("Version", ["properties", "version"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<OperationalInsightsWorkspace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported OperationalInsightsSavedSearch resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-09-01.
        /// </summary>
        public static readonly string V2023_09_01 = "2023-09-01";

        /// <summary>
        /// 2022-10-01.
        /// </summary>
        public static readonly string V2022_10_01 = "2022-10-01";

        /// <summary>
        /// 2021-06-01.
        /// </summary>
        public static readonly string V2021_06_01 = "2021-06-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-08-01.
        /// </summary>
        public static readonly string V2020_08_01 = "2020-08-01";

        /// <summary>
        /// 2015-03-20.
        /// </summary>
        public static readonly string V2015_03_20 = "2015-03-20";
    }

    /// <summary>
    /// Creates a reference to an existing OperationalInsightsSavedSearch.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the OperationalInsightsSavedSearch
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the OperationalInsightsSavedSearch.</param>
    /// <returns>The existing OperationalInsightsSavedSearch resource.</returns>
    public static OperationalInsightsSavedSearch FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
