// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// OperationalInsightsLinkedStorageAccounts.
/// </summary>
public partial class OperationalInsightsLinkedStorageAccounts : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Linked storage accounts type.
    /// </summary>
    public BicepValue<OperationalInsightsDataSourceType> DataSourceType 
    {
        get { Initialize(); return _dataSourceType!; }
        set { Initialize(); _dataSourceType!.Assign(value); }
    }
    private BicepValue<OperationalInsightsDataSourceType>? _dataSourceType;

    /// <summary>
    /// Linked storage accounts resources ids.
    /// </summary>
    public BicepList<ResourceIdentifier> StorageAccountIds 
    {
        get { Initialize(); return _storageAccountIds!; }
        set { Initialize(); _storageAccountIds!.Assign(value); }
    }
    private BicepList<ResourceIdentifier>? _storageAccountIds;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent OperationalInsightsWorkspace.
    /// </summary>
    public OperationalInsightsWorkspace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<OperationalInsightsWorkspace>? _parent;

    /// <summary>
    /// Creates a new OperationalInsightsLinkedStorageAccounts.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// OperationalInsightsLinkedStorageAccounts resource.  This can be used
    /// to refer to the resource in expressions, but is not the Azure name of
    /// the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the OperationalInsightsLinkedStorageAccounts.</param>
    public OperationalInsightsLinkedStorageAccounts(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.OperationalInsights/workspaces/linkedStorageAccounts", resourceVersion ?? "2023-09-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// OperationalInsightsLinkedStorageAccounts.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _dataSourceType = DefineProperty<OperationalInsightsDataSourceType>("DataSourceType", ["properties", "dataSourceType"], isRequired: true);
        _storageAccountIds = DefineListProperty<ResourceIdentifier>("StorageAccountIds", ["properties", "storageAccountIds"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<OperationalInsightsWorkspace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported OperationalInsightsLinkedStorageAccounts resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-09-01.
        /// </summary>
        public static readonly string V2023_09_01 = "2023-09-01";

        /// <summary>
        /// 2020-08-01.
        /// </summary>
        public static readonly string V2020_08_01 = "2020-08-01";
    }

    /// <summary>
    /// Creates a reference to an existing
    /// OperationalInsightsLinkedStorageAccounts.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// OperationalInsightsLinkedStorageAccounts resource.  This can be used
    /// to refer to the resource in expressions, but is not the Azure name of
    /// the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the OperationalInsightsLinkedStorageAccounts.</param>
    /// <returns>The existing OperationalInsightsLinkedStorageAccounts resource.</returns>
    public static OperationalInsightsLinkedStorageAccounts FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
