// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// OperationalInsightsDataExport.
/// </summary>
public partial class OperationalInsightsDataExport : ProvisionableResource
{
    /// <summary>
    /// The data export rule name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The latest data export rule modification time.
    /// </summary>
    public BicepValue<DateTimeOffset> CreatedOn 
    {
        get { Initialize(); return _createdOn!; }
        set { Initialize(); _createdOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _createdOn;

    /// <summary>
    /// The data export rule ID.
    /// </summary>
    public BicepValue<Guid> DataExportId 
    {
        get { Initialize(); return _dataExportId!; }
        set { Initialize(); _dataExportId!.Assign(value); }
    }
    private BicepValue<Guid>? _dataExportId;

    /// <summary>
    /// Optional. Allows to define an Event Hub name. Not applicable when
    /// destination is Storage Account.
    /// </summary>
    public BicepValue<string> EventHubName 
    {
        get { Initialize(); return _eventHubName!; }
        set { Initialize(); _eventHubName!.Assign(value); }
    }
    private BicepValue<string>? _eventHubName;

    /// <summary>
    /// Active when enabled.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Date and time when the export was last modified.
    /// </summary>
    public BicepValue<DateTimeOffset> LastModifiedOn 
    {
        get { Initialize(); return _lastModifiedOn!; }
        set { Initialize(); _lastModifiedOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _lastModifiedOn;

    /// <summary>
    /// The destination resource ID. This can be copied from the Properties
    /// entry of the destination resource in Azure.
    /// </summary>
    public BicepValue<ResourceIdentifier> ResourceId 
    {
        get { Initialize(); return _resourceId!; }
        set { Initialize(); _resourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _resourceId;

    /// <summary>
    /// An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
    /// </summary>
    public BicepList<string> TableNames 
    {
        get { Initialize(); return _tableNames!; }
        set { Initialize(); _tableNames!.Assign(value); }
    }
    private BicepList<string>? _tableNames;

    /// <summary>
    /// The type of the destination resource.
    /// </summary>
    public BicepValue<OperationalInsightsDataExportDestinationType> DestinationType 
    {
        get { Initialize(); return _destinationType!; }
    }
    private BicepValue<OperationalInsightsDataExportDestinationType>? _destinationType;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets or sets a reference to the parent OperationalInsightsWorkspace.
    /// </summary>
    public OperationalInsightsWorkspace? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<OperationalInsightsWorkspace>? _parent;

    /// <summary>
    /// Creates a new OperationalInsightsDataExport.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the OperationalInsightsDataExport
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the OperationalInsightsDataExport.</param>
    public OperationalInsightsDataExport(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.OperationalInsights/workspaces/dataExports", resourceVersion ?? "2023-09-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// OperationalInsightsDataExport.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _createdOn = DefineProperty<DateTimeOffset>("CreatedOn", ["properties", "createdDate"]);
        _dataExportId = DefineProperty<Guid>("DataExportId", ["properties", "dataExportId"]);
        _eventHubName = DefineProperty<string>("EventHubName", ["properties", "eventHubName"]);
        _isEnabled = DefineProperty<bool>("IsEnabled", ["properties", "enable"]);
        _lastModifiedOn = DefineProperty<DateTimeOffset>("LastModifiedOn", ["properties", "lastModifiedDate"]);
        _resourceId = DefineProperty<ResourceIdentifier>("ResourceId", ["properties", "resourceId"]);
        _tableNames = DefineListProperty<string>("TableNames", ["properties", "tableNames"]);
        _destinationType = DefineProperty<OperationalInsightsDataExportDestinationType>("DestinationType", ["properties", "type"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _parent = DefineResource<OperationalInsightsWorkspace>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported OperationalInsightsDataExport resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2023-09-01.
        /// </summary>
        public static readonly string V2023_09_01 = "2023-09-01";

        /// <summary>
        /// 2020-08-01.
        /// </summary>
        public static readonly string V2020_08_01 = "2020-08-01";
    }

    /// <summary>
    /// Creates a reference to an existing OperationalInsightsDataExport.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the OperationalInsightsDataExport
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the OperationalInsightsDataExport.</param>
    /// <returns>The existing OperationalInsightsDataExport resource.</returns>
    public static OperationalInsightsDataExport FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
