// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// The status of the storage insight.
/// </summary>
public partial class StorageInsightStatus : ProvisionableConstruct
{
    /// <summary>
    /// The state of the storage insight connection to the workspace.
    /// </summary>
    public BicepValue<StorageInsightState> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<StorageInsightState>? _state;

    /// <summary>
    /// Description of the state of the storage insight.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Creates a new StorageInsightStatus.
    /// </summary>
    public StorageInsightStatus()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of StorageInsightStatus.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _state = DefineProperty<StorageInsightState>("State", ["state"], isOutput: true);
        _description = DefineProperty<string>("Description", ["description"], isOutput: true);
    }
}
