// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// The SKU (tier) of a workspace.
/// </summary>
public partial class OperationalInsightsWorkspaceSku : ProvisionableConstruct
{
    /// <summary>
    /// The name of the SKU.
    /// </summary>
    public BicepValue<OperationalInsightsWorkspaceSkuName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<OperationalInsightsWorkspaceSkuName>? _name;

    /// <summary>
    /// The capacity reservation level in GB for this workspace, when
    /// CapacityReservation sku is selected.
    /// </summary>
    public BicepValue<OperationalInsightsWorkspaceCapacityReservationLevel> CapacityReservationLevel 
    {
        get { Initialize(); return _capacityReservationLevel!; }
        set { Initialize(); _capacityReservationLevel!.Assign(value); }
    }
    private BicepValue<OperationalInsightsWorkspaceCapacityReservationLevel>? _capacityReservationLevel;

    /// <summary>
    /// The last time when the sku was updated.
    /// </summary>
    public BicepValue<DateTimeOffset> LastSkuUpdatedOn 
    {
        get { Initialize(); return _lastSkuUpdatedOn!; }
    }
    private BicepValue<DateTimeOffset>? _lastSkuUpdatedOn;

    /// <summary>
    /// Creates a new OperationalInsightsWorkspaceSku.
    /// </summary>
    public OperationalInsightsWorkspaceSku()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// OperationalInsightsWorkspaceSku.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<OperationalInsightsWorkspaceSkuName>("Name", ["name"]);
        _capacityReservationLevel = DefineProperty<OperationalInsightsWorkspaceCapacityReservationLevel>("CapacityReservationLevel", ["capacityReservationLevel"]);
        _lastSkuUpdatedOn = DefineProperty<DateTimeOffset>("LastSkuUpdatedOn", ["lastSkuUpdate"], isOutput: true);
    }
}
