// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Expressions;
using Azure.Provisioning.Primitives;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// The shared keys for a workspace.
/// </summary>
public partial class OperationalInsightsWorkspaceSharedKeys : ProvisionableConstruct
{
    /// <summary>
    /// The primary shared key of a workspace.
    /// </summary>
    public BicepValue<string> PrimarySharedKey 
    {
        get { Initialize(); return _primarySharedKey!; }
    }
    private BicepValue<string>? _primarySharedKey;

    /// <summary>
    /// The secondary shared key of a workspace.
    /// </summary>
    public BicepValue<string> SecondarySharedKey 
    {
        get { Initialize(); return _secondarySharedKey!; }
    }
    private BicepValue<string>? _secondarySharedKey;

    /// <summary>
    /// Creates a new OperationalInsightsWorkspaceSharedKeys.
    /// </summary>
    public OperationalInsightsWorkspaceSharedKeys()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// OperationalInsightsWorkspaceSharedKeys.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _primarySharedKey = DefineProperty<string>("PrimarySharedKey", ["primarySharedKey"], isOutput: true, isSecure: true);
        _secondarySharedKey = DefineProperty<string>("SecondarySharedKey", ["secondarySharedKey"], isOutput: true, isSecure: true);
    }
}
