// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// Workspace features.
/// </summary>
public partial class OperationalInsightsWorkspaceFeatures : ProvisionableConstruct
{
    /// <summary>
    /// Flag that indicate if data should be exported.
    /// </summary>
    public BicepValue<bool> IsDataExportEnabled 
    {
        get { Initialize(); return _isDataExportEnabled!; }
        set { Initialize(); _isDataExportEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isDataExportEnabled;

    /// <summary>
    /// Flag that describes if we want to remove the data after 30 days.
    /// </summary>
    public BicepValue<bool> ImmediatePurgeDataOn30Days 
    {
        get { Initialize(); return _immediatePurgeDataOn30Days!; }
        set { Initialize(); _immediatePurgeDataOn30Days!.Assign(value); }
    }
    private BicepValue<bool>? _immediatePurgeDataOn30Days;

    /// <summary>
    /// Flag that indicate which permission to use - resource or workspace or
    /// both.
    /// </summary>
    public BicepValue<bool> IsLogAccessUsingOnlyResourcePermissionsEnabled 
    {
        get { Initialize(); return _isLogAccessUsingOnlyResourcePermissionsEnabled!; }
        set { Initialize(); _isLogAccessUsingOnlyResourcePermissionsEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isLogAccessUsingOnlyResourcePermissionsEnabled;

    /// <summary>
    /// Dedicated LA cluster resourceId that is linked to the workspaces.
    /// </summary>
    public BicepValue<ResourceIdentifier> ClusterResourceId 
    {
        get { Initialize(); return _clusterResourceId!; }
        set { Initialize(); _clusterResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _clusterResourceId;

    /// <summary>
    /// Disable Non-AAD based Auth.
    /// </summary>
    public BicepValue<bool> IsLocalAuthDisabled 
    {
        get { Initialize(); return _isLocalAuthDisabled!; }
        set { Initialize(); _isLocalAuthDisabled!.Assign(value); }
    }
    private BicepValue<bool>? _isLocalAuthDisabled;

    /// <summary>
    /// Additional Properties                          To assign an object to
    /// the value of this property use
    /// System.BinaryData.FromObjectAsJson``1(``0,System.Text.Json.JsonSerializerOptions).
    /// To assign an already formatted json string to
    /// this property use System.BinaryData.FromString(System.String).
    /// Examples:
    /// BinaryData.FromObjectAsJson(&quot;foo&quot;)Creates a
    /// payload of
    /// &quot;foo&quot;.BinaryData.FromString(&quot;\&quot;foo\&quot;&quot;)Creates
    /// a payload of &quot;foo&quot;.BinaryData.FromObjectAsJson(new { key =
    /// &quot;value&quot; })Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.BinaryData.FromString(&quot;{\&quot;key\&quot;:
    /// \&quot;value\&quot;}&quot;)Creates a payload of { &quot;key&quot;:
    /// &quot;value&quot; }.
    /// </summary>
    public BicepDictionary<BinaryData> AdditionalProperties 
    {
        get { Initialize(); return _additionalProperties!; }
        set { Initialize(); _additionalProperties!.Assign(value); }
    }
    private BicepDictionary<BinaryData>? _additionalProperties;

    /// <summary>
    /// Creates a new OperationalInsightsWorkspaceFeatures.
    /// </summary>
    public OperationalInsightsWorkspaceFeatures()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// OperationalInsightsWorkspaceFeatures.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isDataExportEnabled = DefineProperty<bool>("IsDataExportEnabled", ["enableDataExport"]);
        _immediatePurgeDataOn30Days = DefineProperty<bool>("ImmediatePurgeDataOn30Days", ["immediatePurgeDataOn30Days"]);
        _isLogAccessUsingOnlyResourcePermissionsEnabled = DefineProperty<bool>("IsLogAccessUsingOnlyResourcePermissionsEnabled", ["enableLogAccessUsingOnlyResourcePermissions"]);
        _clusterResourceId = DefineProperty<ResourceIdentifier>("ClusterResourceId", ["clusterResourceId"]);
        _isLocalAuthDisabled = DefineProperty<bool>("IsLocalAuthDisabled", ["disableLocalAuth"]);
        _additionalProperties = DefineDictionaryProperty<BinaryData>("AdditionalProperties", ["AdditionalProperties"]);
    }
}
