// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// The daily volume cap for ingestion.
/// </summary>
public partial class OperationalInsightsWorkspaceCapping : ProvisionableConstruct
{
    /// <summary>
    /// The workspace daily quota for ingestion.
    /// </summary>
    public BicepValue<double> DailyQuotaInGB 
    {
        get { Initialize(); return _dailyQuotaInGB!; }
        set { Initialize(); _dailyQuotaInGB!.Assign(value); }
    }
    private BicepValue<double>? _dailyQuotaInGB;

    /// <summary>
    /// The time when the quota will be rest.
    /// </summary>
    public BicepValue<string> QuotaNextResetTime 
    {
        get { Initialize(); return _quotaNextResetTime!; }
    }
    private BicepValue<string>? _quotaNextResetTime;

    /// <summary>
    /// The status of data ingestion for this workspace.
    /// </summary>
    public BicepValue<OperationalInsightsDataIngestionStatus> DataIngestionStatus 
    {
        get { Initialize(); return _dataIngestionStatus!; }
    }
    private BicepValue<OperationalInsightsDataIngestionStatus>? _dataIngestionStatus;

    /// <summary>
    /// Creates a new OperationalInsightsWorkspaceCapping.
    /// </summary>
    public OperationalInsightsWorkspaceCapping()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// OperationalInsightsWorkspaceCapping.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _dailyQuotaInGB = DefineProperty<double>("DailyQuotaInGB", ["dailyQuotaGb"]);
        _quotaNextResetTime = DefineProperty<string>("QuotaNextResetTime", ["quotaNextResetTime"], isOutput: true);
        _dataIngestionStatus = DefineProperty<OperationalInsightsDataIngestionStatus>("DataIngestionStatus", ["dataIngestionStatus"], isOutput: true);
    }
}
