// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// The subtype describes what APIs can be used to interact with the table, and
/// what features are available against it.
/// </summary>
public enum OperationalInsightsTableSubType
{
    /// <summary>
    /// The default subtype with which built-in tables are created.
    /// </summary>
    Any,

    /// <summary>
    /// Indicates a table created through the Data Collector API or with the
    /// custom logs feature of the MMA agent, or any table against which
    /// Custom Fields were created.
    /// </summary>
    Classic,

    /// <summary>
    /// A table eligible to have data sent into it via any of the means
    /// supported by Data Collection Rules: the Data Collection Endpoint API,
    /// ingestion-time transformations, or any other mechanism provided by
    /// Data Collection Rules.
    /// </summary>
    DataCollectionRuleBased,
}
