// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// Parameters of the search job that initiated this table.
/// </summary>
public partial class OperationalInsightsTableSearchResults : ProvisionableConstruct
{
    /// <summary>
    /// Search job query.
    /// </summary>
    public BicepValue<string> Query 
    {
        get { Initialize(); return _query!; }
        set { Initialize(); _query!.Assign(value); }
    }
    private BicepValue<string>? _query;

    /// <summary>
    /// Search job Description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// Limit the search job to return up to specified number of rows.
    /// </summary>
    public BicepValue<int> Limit 
    {
        get { Initialize(); return _limit!; }
        set { Initialize(); _limit!.Assign(value); }
    }
    private BicepValue<int>? _limit;

    /// <summary>
    /// The timestamp to start the search from (UTC).
    /// </summary>
    public BicepValue<DateTimeOffset> StartSearchOn 
    {
        get { Initialize(); return _startSearchOn!; }
        set { Initialize(); _startSearchOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _startSearchOn;

    /// <summary>
    /// The timestamp to end the search by (UTC).
    /// </summary>
    public BicepValue<DateTimeOffset> EndSearchOn 
    {
        get { Initialize(); return _endSearchOn!; }
        set { Initialize(); _endSearchOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _endSearchOn;

    /// <summary>
    /// The table used in the search job.
    /// </summary>
    public BicepValue<string> SourceTable 
    {
        get { Initialize(); return _sourceTable!; }
    }
    private BicepValue<string>? _sourceTable;

    /// <summary>
    /// Search results table async operation id.
    /// </summary>
    public BicepValue<Guid> AzureAsyncOperationId 
    {
        get { Initialize(); return _azureAsyncOperationId!; }
    }
    private BicepValue<Guid>? _azureAsyncOperationId;

    /// <summary>
    /// Creates a new OperationalInsightsTableSearchResults.
    /// </summary>
    public OperationalInsightsTableSearchResults()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// OperationalInsightsTableSearchResults.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _query = DefineProperty<string>("Query", ["query"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _limit = DefineProperty<int>("Limit", ["limit"]);
        _startSearchOn = DefineProperty<DateTimeOffset>("StartSearchOn", ["startSearchTime"]);
        _endSearchOn = DefineProperty<DateTimeOffset>("EndSearchOn", ["endSearchTime"]);
        _sourceTable = DefineProperty<string>("SourceTable", ["sourceTable"], isOutput: true);
        _azureAsyncOperationId = DefineProperty<Guid>("AzureAsyncOperationId", ["azureAsyncOperationId"], isOutput: true);
    }
}
