// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// Restore parameters.
/// </summary>
public partial class OperationalInsightsTableRestoredLogs : ProvisionableConstruct
{
    /// <summary>
    /// The timestamp to start the restore from (UTC).
    /// </summary>
    public BicepValue<DateTimeOffset> StartRestoreOn 
    {
        get { Initialize(); return _startRestoreOn!; }
        set { Initialize(); _startRestoreOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _startRestoreOn;

    /// <summary>
    /// The timestamp to end the restore by (UTC).
    /// </summary>
    public BicepValue<DateTimeOffset> EndRestoreOn 
    {
        get { Initialize(); return _endRestoreOn!; }
        set { Initialize(); _endRestoreOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _endRestoreOn;

    /// <summary>
    /// The table to restore data from.
    /// </summary>
    public BicepValue<string> SourceTable 
    {
        get { Initialize(); return _sourceTable!; }
        set { Initialize(); _sourceTable!.Assign(value); }
    }
    private BicepValue<string>? _sourceTable;

    /// <summary>
    /// Search results table async operation id.
    /// </summary>
    public BicepValue<Guid> AzureAsyncOperationId 
    {
        get { Initialize(); return _azureAsyncOperationId!; }
    }
    private BicepValue<Guid>? _azureAsyncOperationId;

    /// <summary>
    /// Creates a new OperationalInsightsTableRestoredLogs.
    /// </summary>
    public OperationalInsightsTableRestoredLogs()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// OperationalInsightsTableRestoredLogs.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _startRestoreOn = DefineProperty<DateTimeOffset>("StartRestoreOn", ["startRestoreTime"]);
        _endRestoreOn = DefineProperty<DateTimeOffset>("EndRestoreOn", ["endRestoreTime"]);
        _sourceTable = DefineProperty<string>("SourceTable", ["sourceTable"]);
        _azureAsyncOperationId = DefineProperty<Guid>("AzureAsyncOperationId", ["azureAsyncOperationId"], isOutput: true);
    }
}
