// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// Describes a storage account connection.
/// </summary>
public partial class OperationalInsightsStorageAccount : ProvisionableConstruct
{
    /// <summary>
    /// The Azure Resource Manager ID of the storage account resource.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// The storage account key.
    /// </summary>
    public BicepValue<string> Key 
    {
        get { Initialize(); return _key!; }
        set { Initialize(); _key!.Assign(value); }
    }
    private BicepValue<string>? _key;

    /// <summary>
    /// Creates a new OperationalInsightsStorageAccount.
    /// </summary>
    public OperationalInsightsStorageAccount()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// OperationalInsightsStorageAccount.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"]);
        _key = DefineProperty<string>("Key", ["key"]);
    }
}
