// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// Table&apos;s schema.
/// </summary>
public partial class OperationalInsightsSchema : ProvisionableConstruct
{
    /// <summary>
    /// Table name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Table display name.
    /// </summary>
    public BicepValue<string> DisplayName 
    {
        get { Initialize(); return _displayName!; }
        set { Initialize(); _displayName!.Assign(value); }
    }
    private BicepValue<string>? _displayName;

    /// <summary>
    /// Table description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// A list of table custom columns.
    /// </summary>
    public BicepList<OperationalInsightsColumn> Columns 
    {
        get { Initialize(); return _columns!; }
        set { Initialize(); _columns!.Assign(value); }
    }
    private BicepList<OperationalInsightsColumn>? _columns;

    /// <summary>
    /// A list of table standard columns.
    /// </summary>
    public BicepList<OperationalInsightsColumn> StandardColumns 
    {
        get { Initialize(); return _standardColumns!; }
    }
    private BicepList<OperationalInsightsColumn>? _standardColumns;

    /// <summary>
    /// Table category.
    /// </summary>
    public BicepList<string> Categories 
    {
        get { Initialize(); return _categories!; }
    }
    private BicepList<string>? _categories;

    /// <summary>
    /// Table labels.
    /// </summary>
    public BicepList<string> Labels 
    {
        get { Initialize(); return _labels!; }
    }
    private BicepList<string>? _labels;

    /// <summary>
    /// Table&apos;s creator.
    /// </summary>
    public BicepValue<OperationalInsightsTableCreator> Source 
    {
        get { Initialize(); return _source!; }
    }
    private BicepValue<OperationalInsightsTableCreator>? _source;

    /// <summary>
    /// Table&apos;s creator.
    /// </summary>
    public BicepValue<OperationalInsightsTableType> TableType 
    {
        get { Initialize(); return _tableType!; }
    }
    private BicepValue<OperationalInsightsTableType>? _tableType;

    /// <summary>
    /// The subtype describes what APIs can be used to interact with the table,
    /// and what features are available against it.
    /// </summary>
    public BicepValue<OperationalInsightsTableSubType> TableSubType 
    {
        get { Initialize(); return _tableSubType!; }
    }
    private BicepValue<OperationalInsightsTableSubType>? _tableSubType;

    /// <summary>
    /// List of solutions the table is affiliated with.
    /// </summary>
    public BicepList<string> Solutions 
    {
        get { Initialize(); return _solutions!; }
    }
    private BicepList<string>? _solutions;

    /// <summary>
    /// Creates a new OperationalInsightsSchema.
    /// </summary>
    public OperationalInsightsSchema()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of OperationalInsightsSchema.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _displayName = DefineProperty<string>("DisplayName", ["displayName"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _columns = DefineListProperty<OperationalInsightsColumn>("Columns", ["columns"]);
        _standardColumns = DefineListProperty<OperationalInsightsColumn>("StandardColumns", ["standardColumns"], isOutput: true);
        _categories = DefineListProperty<string>("Categories", ["categories"], isOutput: true);
        _labels = DefineListProperty<string>("Labels", ["labels"], isOutput: true);
        _source = DefineProperty<OperationalInsightsTableCreator>("Source", ["source"], isOutput: true);
        _tableType = DefineProperty<OperationalInsightsTableType>("TableType", ["tableType"], isOutput: true);
        _tableSubType = DefineProperty<OperationalInsightsTableSubType>("TableSubType", ["tableSubType"], isOutput: true);
        _solutions = DefineListProperty<string>("Solutions", ["solutions"], isOutput: true);
    }
}
