// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.OperationalInsights;

/// <summary>
/// The private link scope resource reference.
/// </summary>
public partial class OperationalInsightsPrivateLinkScopedResourceInfo : ProvisionableConstruct
{
    /// <summary>
    /// The full resource Id of the private link scope resource.
    /// </summary>
    public BicepValue<ResourceIdentifier> ResourceId 
    {
        get { Initialize(); return _resourceId!; }
    }
    private BicepValue<ResourceIdentifier>? _resourceId;

    /// <summary>
    /// The private link scope unique Identifier.
    /// </summary>
    public BicepValue<string> ScopeId 
    {
        get { Initialize(); return _scopeId!; }
    }
    private BicepValue<string>? _scopeId;

    /// <summary>
    /// Creates a new OperationalInsightsPrivateLinkScopedResourceInfo.
    /// </summary>
    public OperationalInsightsPrivateLinkScopedResourceInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// OperationalInsightsPrivateLinkScopedResourceInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _resourceId = DefineProperty<ResourceIdentifier>("ResourceId", ["resourceId"], isOutput: true);
        _scopeId = DefineProperty<string>("ScopeId", ["scopeId"], isOutput: true);
    }
}
